/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.api.control;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlState;
import de.rayzs.controlplayer.api.control.ControlSwap;
import de.rayzs.controlplayer.api.files.messages.MessageManager;
import de.rayzs.controlplayer.api.files.messages.MessageType;
import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.api.files.settings.SettingsManager;
import de.rayzs.controlplayer.api.listener.ControlPlayerEventManager;
import de.rayzs.controlplayer.api.listener.ControlPlayerEventType;
import de.rayzs.controlplayer.api.packetbased.actionbar.Actionbar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class ControlManager {
    private static Plugin plugin = null;
    private static final HashMap<ControlInstance, ControlSwap> SWAPPED_INSTANCES = new HashMap();
    private static final HashMap<Player, Integer> LAST_FOODLEVEL = new HashMap();
    private static final HashMap<Player, Integer> LAST_LEVEL = new HashMap();
    private static final HashMap<Player, Integer> LAST_TOTALEXCPERIENCE = new HashMap();
    private static final HashMap<Player, Boolean> LAST_ALLOWED_FLIGHT = new HashMap();
    private static final HashMap<Player, Boolean> LAST_FLYING = new HashMap();
    private static final HashMap<Player, Boolean> LAST_COLLISION = new HashMap();
    private static final HashMap<Player, ItemStack[]> LAST_INVENTORY = new HashMap();
    private static final HashMap<Player, ItemStack[]> LAST_ARMOR = new HashMap();
    private static final HashMap<Player, Double> LAST_HEALTH = new HashMap();
    private static final HashMap<Player, Double> LAST_HEALTHSCALE = new HashMap();
    private static final HashMap<Player, Float> LAST_EXP = new HashMap();
    private static final HashMap<Player, Float> LAST_EXHAUSTION = new HashMap();
    private static final HashMap<Player, Location> LAST_LOCATION = new HashMap();
    private static final HashMap<Player, GameMode> LAST_GAMEMODE = new HashMap();
    private static final HashMap<Player, List<Player>> PLAYER_WHO_CAN_SEE = new HashMap();
    private static final HashMap<Player, List<PotionEffect>> LAST_EFFECTS = new HashMap();
    private static final HashMap<String, Long> QUEUE_MESSAGES = new HashMap();
    private static final List<ControlInstance> INSTANCES = new ArrayList<ControlInstance>();
    private static boolean cancelCollision = true;
    private static boolean apiMode;
    private static boolean sendActionbar;
    private static boolean syncFoodLevel;
    private static boolean returnInventory;
    private static boolean returnLocation;
    private static boolean returnHealth;
    private static boolean returnFoodLevel;
    private static boolean returnGamemode;
    private static boolean returnFlight;
    private static boolean returnLevel;
    private static Actionbar actionbar;
    private static String controllingActionbarText;
    private static String waitingActionbarText;

    public static void loadSettings() {
        apiMode = (Boolean)SettingsManager.getSetting(SettingType.APIMODE);
        sendActionbar = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_RUNNING_ACTIONBAR_ENABLED);
        syncFoodLevel = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_RUNNING_SYNC_FOODLEVEL);
        returnInventory = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_INVENTORY);
        returnLocation = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_LOCATION);
        returnHealth = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_HEALTH);
        returnFoodLevel = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_FOODLEVEL);
        returnGamemode = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_GAMEMODE);
        returnFlight = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_FLIGHT);
        returnLevel = (Boolean)SettingsManager.getSetting(SettingType.CONTROL_STOP_RETURN_LEVEL);
    }

    public static void load(Plugin bukkitPlugin) {
        plugin = bukkitPlugin;
        ControlManager.loadSettings();
        int delay = (Integer)SettingsManager.getSetting(SettingType.CONTROL_RUNNING_SYNCDELAY);
        Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, () -> {
            if (!INSTANCES.isEmpty()) {
                INSTANCES.forEach(instance -> {
                    ControlPlayerEventManager.call(ControlPlayerEventType.RUNNING, instance.controller(), instance.victim());
                    if (!apiMode) {
                        instance.onTick();
                    }
                });
            }
        }, 0L, (long)delay);
        Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, () -> {
            if (!INSTANCES.isEmpty()) {
                INSTANCES.forEach(instance -> {
                    if (!apiMode) {
                        ControlSwap swap = ControlManager.getControlSwap(instance);
                        if (swap != null && swap.isEnabled()) {
                            boolean swapped = swap.isSwapped();
                            if (sendActionbar) {
                                actionbar.execute(instance.controller(), (swapped ? waitingActionbarText : controllingActionbarText).replace("%player%", instance.victim().getName()));
                            }
                            Player controller = swapped ? instance.victim() : instance.controller();
                            Player victim = swapped ? instance.controller() : instance.victim();
                            String openInventoryType = controller.getOpenInventory().getType().name();
                            if (openInventoryType.contains("CRAFTING") || openInventoryType.contains("CREATIVE")) {
                                victim.teleport(controller.getLocation());
                            }
                        } else {
                            InventoryType openInventoryType;
                            if (sendActionbar) {
                                actionbar.execute(instance.controller(), controllingActionbarText.replace("%player%", instance.victim().getName()));
                            }
                            if ((openInventoryType = instance.controller().getOpenInventory().getType()) == InventoryType.CRAFTING || openInventoryType == InventoryType.CREATIVE) {
                                instance.victim().teleport(instance.controller().getLocation());
                            }
                        }
                    }
                });
            }
        }, 0L, 0L);
    }

    public static ControlState createControlInstance(final Player controller, final Player victim, boolean useSwap) {
        if (controller == null || victim == null || !controller.isOnline() || !victim.isOnline()) {
            return ControlState.OFFLINE;
        }
        int controllerState = ControlManager.getInstanceState(controller);
        int victimState = ControlManager.getInstanceState(victim);
        if (controllerState != -1) {
            return ControlState.ALREADY_CONTROLLING;
        }
        if (victimState != -1) {
            return ControlState.ALREADY_CONTROLLED;
        }
        ControlInstance controlInstance = new ControlInstance(){

            @Override
            public Player victim() {
                return victim;
            }

            @Override
            public Player controller() {
                return controller;
            }

            @Override
            public void onTick() {
                ControlPlayerEventManager.call(ControlPlayerEventType.RUNNING, controller, victim);
                if (!apiMode) {
                    ControlSwap swap = ControlManager.getControlSwap(this);
                    if (swap != null && swap.isEnabled()) {
                        boolean swapped = swap.isSwapped();
                        ControlManager.syncPlayers(swapped ? victim : controller, swapped ? controller : victim, false);
                    } else {
                        ControlManager.syncPlayers(controller, victim, false);
                    }
                }
            }
        };
        SWAPPED_INSTANCES.put(controlInstance, new ControlSwap(useSwap));
        INSTANCES.add(controlInstance);
        ControlPlayerEventManager.call(ControlPlayerEventType.START, controller, victim);
        if (!apiMode) {
            ArrayList players_who_can_see = new ArrayList();
            Bukkit.getOnlinePlayers().forEach(players -> {
                if (players.canSee(controller)) {
                    players_who_can_see.add(players);
                }
            });
            PLAYER_WHO_CAN_SEE.put(controller, players_who_can_see);
            Bukkit.getOnlinePlayers().forEach(ControlManager::hideAllControllers);
            ControlManager.saveOrReturnController(controller, false);
            ControlManager.syncPlayers(controller, victim, true);
            if (cancelCollision) {
                try {
                    victim.spigot().setCollidesWithEntities(false);
                }
                catch (Throwable exception) {
                    cancelCollision = false;
                }
            }
        }
        return ControlState.SUCCESS;
    }

    public static void hideAllControllers(Player player) {
        Bukkit.getOnlinePlayers().stream().filter(controllers -> ControlManager.getInstanceState(controllers) == 0).forEach(controllers -> {
            if (player.canSee(controllers)) {
                List<Player> player_who_can_see = PLAYER_WHO_CAN_SEE.get(controllers);
                player_who_can_see.add(player);
            }
            player.hidePlayer(controllers);
        });
    }

    public static boolean deleteControlInstance(Player player) {
        Optional<ControlInstance> instanceOption = INSTANCES.stream().filter(instance -> instance.controller() == player || instance.victim() == player).findFirst();
        if (instanceOption.isPresent()) {
            ControlInstance controlInstance = instanceOption.get();
            Player victim = controlInstance.victim();
            Player controller = controlInstance.controller();
            ControlManager.resetVictimMessages(victim);
            if (victim != null && controller != null) {
                controlInstance.controller().showPlayer(controlInstance.victim());
            }
            if (victim != null && cancelCollision) {
                try {
                    victim.spigot().setCollidesWithEntities(LAST_COLLISION.get(player).booleanValue());
                }
                catch (Throwable exception) {
                    cancelCollision = false;
                }
            }
            INSTANCES.remove(controlInstance);
            if (controller != null) {
                ControlPlayerEventManager.call(ControlPlayerEventType.STOP, controller, victim);
                if (!apiMode) {
                    ControlManager.saveOrReturnController(controller, true);
                }
            }
            return true;
        }
        return false;
    }

    public static void deleteSafeControlInstance(Player player) {
        Optional<ControlInstance> instanceOption = INSTANCES.stream().filter(instance -> instance.controller() == player || instance.victim() == player).findFirst();
        if (instanceOption.isPresent()) {
            ControlInstance controlInstance = instanceOption.get();
            Player victim = controlInstance.victim();
            Player controller = controlInstance.controller();
            ControlManager.resetVictimMessages(victim);
            if (victim != null && controller != null) {
                controlInstance.controller().showPlayer(controlInstance.victim());
            }
            if (victim != null && cancelCollision) {
                try {
                    victim.spigot().setCollidesWithEntities(LAST_COLLISION.get(player).booleanValue());
                }
                catch (Throwable exception) {
                    cancelCollision = false;
                }
            }
            INSTANCES.remove(controlInstance);
            if (controller == null) {
                return;
            }
            ControlPlayerEventManager.call(ControlPlayerEventType.STOP, controller, victim);
            if (!apiMode) {
                controller.setHealth(20.0);
                Bukkit.getScheduler().runTaskLater(plugin, () -> ControlManager.saveOrReturnController(controller, true), 1L);
            }
        }
    }

    public static ControlInstance getControlInstance(Player player) {
        Optional<ControlInstance> instanceOption = INSTANCES.stream().filter(instance -> instance.controller() == player || instance.victim() == player).findFirst();
        return instanceOption.orElse(null);
    }

    public static ControlSwap getControlSwap(ControlInstance instance) {
        return SWAPPED_INSTANCES.get(instance);
    }

    public static int getInstanceState(Player player) {
        AtomicBoolean isOwner = new AtomicBoolean(false);
        Optional<ControlInstance> instanceOption = INSTANCES.stream().filter(instance -> {
            if (instance.controller() == player) {
                isOwner.set(true);
                return true;
            }
            return false;
        }).findFirst();
        return instanceOption.isPresent() && isOwner.get() ? 0 : (instanceOption.isPresent() && !isOwner.get() ? 1 : (ControlManager.getControlInstance(player) != null && !isOwner.get() ? 1 : -1));
    }

    public static void fixPlayer(Player player) {
        if (cancelCollision) {
            try {
                player.spigot().setCollidesWithEntities(true);
                LAST_COLLISION.put(player, true);
            }
            catch (Throwable exception) {
                cancelCollision = false;
            }
        }
    }

    protected static void syncPlayers(Player controller, Player victim, boolean start) {
        if (start) {
            controller.hidePlayer(victim);
            controller.teleport(victim.getLocation());
            controller.setHealthScale(victim.getHealthScale());
            ControlManager.syncPlayerSources(controller, victim);
            return;
        }
        ControlManager.syncPlayerSources(victim, controller);
    }

    public static HashMap<String, Long> getQueueMessages() {
        return QUEUE_MESSAGES;
    }

    public static void resetVictimMessages(Player victim) {
        ArrayList targetKeys = new ArrayList();
        ControlManager.getQueueMessages().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(victim.getUniqueId() + "==")).forEach(entry -> targetKeys.add((String)entry.getKey()));
        for (String targetKey : targetKeys) {
            QUEUE_MESSAGES.remove(targetKey);
        }
    }

    protected static void syncPlayerSources(Player player, Player sourcePlayer) {
        player.getInventory().setContents(sourcePlayer.getInventory().getContents());
        player.getInventory().setArmorContents(sourcePlayer.getInventory().getArmorContents());
        if (sourcePlayer.getHealth() >= 0.5) {
            player.setHealth(sourcePlayer.getHealth());
        }
        if (syncFoodLevel) {
            player.setFoodLevel(sourcePlayer.getFoodLevel());
        }
        player.setLevel(sourcePlayer.getLevel());
        player.setExp(sourcePlayer.getExp());
        player.setFireTicks(sourcePlayer.getFireTicks());
        player.setExhaustion(sourcePlayer.getExhaustion());
        player.setAllowFlight(sourcePlayer.getAllowFlight());
        player.setFlying(sourcePlayer.isFlying());
        player.setGameMode(sourcePlayer.getGameMode());
        player.getInventory().setHeldItemSlot(sourcePlayer.getInventory().getHeldItemSlot());
        if (sourcePlayer.getActivePotionEffects().size() > 0) {
            sourcePlayer.getActivePotionEffects().forEach(arg_0 -> ((Player)player).addPotionEffect(arg_0));
        } else {
            player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        }
    }

    protected static void saveOrReturnController(Player player, boolean load) {
        if (load) {
            if (returnInventory) {
                player.getInventory().setContents(LAST_INVENTORY.get(player));
                player.getInventory().setArmorContents(LAST_ARMOR.get(player));
            }
            if (returnFlight) {
                player.setAllowFlight(LAST_ALLOWED_FLIGHT.get(player).booleanValue());
                player.setFlying(LAST_FLYING.get(player).booleanValue());
            }
            if (returnLevel) {
                player.setLevel(LAST_LEVEL.get(player).intValue());
                player.setExhaustion(LAST_EXHAUSTION.get(player).floatValue());
                player.setExp(LAST_EXP.get(player).floatValue());
                player.setTotalExperience(LAST_TOTALEXCPERIENCE.get(player).intValue());
            }
            if (returnHealth) {
                double health;
                double healthScale = LAST_HEALTHSCALE.get(player);
                if (healthScale > (health = LAST_HEALTH.get(player).doubleValue())) {
                    player.setHealthScale(healthScale);
                    player.setHealth(health);
                } else {
                    player.setHealth(health);
                    player.setHealthScale(healthScale);
                }
            }
            if (returnLocation) {
                player.teleport(LAST_LOCATION.get(player));
            }
            if (returnFoodLevel) {
                player.setFoodLevel(LAST_FOODLEVEL.get(player).intValue());
            }
            if (returnGamemode) {
                player.setGameMode(LAST_GAMEMODE.get(player));
            }
            PLAYER_WHO_CAN_SEE.get(player).stream().filter(OfflinePlayer::isOnline).forEach(players -> players.showPlayer(player));
            PLAYER_WHO_CAN_SEE.remove(player);
        } else {
            if (cancelCollision) {
                try {
                    LAST_COLLISION.put(player, player.spigot().getCollidesWithEntities());
                }
                catch (Throwable exception) {
                    cancelCollision = false;
                }
            }
            if (returnInventory) {
                LAST_INVENTORY.put(player, player.getInventory().getContents());
                LAST_ARMOR.put(player, player.getInventory().getArmorContents());
            }
            if (returnFlight) {
                LAST_ALLOWED_FLIGHT.put(player, player.getAllowFlight());
                LAST_FLYING.put(player, player.isFlying());
            }
            if (returnLevel) {
                LAST_LEVEL.put(player, player.getLevel());
                LAST_EXHAUSTION.put(player, Float.valueOf(player.getExhaustion()));
                LAST_EXP.put(player, Float.valueOf(player.getExp()));
                LAST_TOTALEXCPERIENCE.put(player, player.getTotalExperience());
            }
            if (returnHealth) {
                LAST_HEALTHSCALE.put(player, player.getHealthScale());
                LAST_HEALTH.put(player, player.getHealth());
            }
            if (returnLocation) {
                LAST_LOCATION.put(player, player.getLocation());
            }
            if (returnFoodLevel) {
                LAST_FOODLEVEL.put(player, player.getFoodLevel());
            }
            if (returnGamemode) {
                LAST_GAMEMODE.put(player, player.getGameMode());
            }
        }
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    static {
        actionbar = new Actionbar();
        controllingActionbarText = MessageManager.getMessage(MessageType.CONTROLLING_ACTIONBAR_TEXT);
        waitingActionbarText = MessageManager.getMessage(MessageType.WAITING_ACTIONBAR_TEXT);
    }
}

