/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler.storage;

import com.akselglyholt.velocityLimboHandler.VelocityLimboHandler;
import com.akselglyholt.velocityLimboHandler.auth.AuthManager;
import com.akselglyholt.velocityLimboHandler.libs.route.Route;
import com.akselglyholt.velocityLimboHandler.misc.MessageFormatter;
import com.akselglyholt.velocityLimboHandler.misc.Utility;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class PlayerManager {
    private final Map<Player, String> playerData;
    private final Map<Player, Boolean> connectingPlayers;
    private final Map<String, Queue<Player>> reconnectQueues = new ConcurrentHashMap<String, Queue<Player>>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<UUID, String> playerConnectionIssues = new ConcurrentHashMap<UUID, String>();
    private static String queuePositionMsg;

    private boolean isAuthBlocked(Player player) {
        AuthManager am = VelocityLimboHandler.getAuthManager();
        return am != null && am.isAuthBlocked(player);
    }

    public PlayerManager() {
        this.playerData = new ConcurrentHashMap<Player, String>();
        this.connectingPlayers = new ConcurrentHashMap<Player, Boolean>();
        queuePositionMsg = VelocityLimboHandler.getMessageConfig().getString(Route.from((Object)"queuePositionJoin"));
    }

    public void addPlayer(Player player, RegisteredServer registeredServer) {
        if (this.playerData.containsKey(player)) {
            return;
        }
        if (this.isAuthBlocked(player)) {
            return;
        }
        String serverName = registeredServer.getServerInfo().getName();
        this.playerData.put(player, serverName);
        Utility.sendWelcomeMessage(player, null);
        Queue queue = this.reconnectQueues.computeIfAbsent(serverName, s -> new ConcurrentLinkedQueue());
        if (VelocityLimboHandler.isQueueEnabled() && !queue.contains(player)) {
            this.addPlayerToQueue(player, registeredServer);
            String formatedMsg = MessageFormatter.formatMessage(queuePositionMsg, player);
            player.sendMessage(this.miniMessage.deserialize((Object)formatedMsg));
        }
    }

    public void removePlayer(Player player) {
        this.removePlayerFromQueue(player);
        this.playerData.remove(player);
        this.connectingPlayers.remove(player);
        VelocityLimboHandler.getReconnectBlocker().unblock(player.getUniqueId());
    }

    public RegisteredServer getPreviousServer(Player player) {
        String serverName = this.playerData.get(player);
        if (serverName != null) {
            return VelocityLimboHandler.getProxyServer().getServer(serverName).orElse(VelocityLimboHandler.getDirectConnectServer());
        }
        return VelocityLimboHandler.getDirectConnectServer();
    }

    public boolean isPlayerRegistered(Player player) {
        return this.playerData.containsKey(player);
    }

    public void addPlayerToQueue(Player player, RegisteredServer server) {
        this.reconnectQueues.computeIfAbsent(server.getServerInfo().getName(), s -> new ConcurrentLinkedQueue()).add(player);
    }

    public void removePlayerFromQueue(Player player) {
        String serverName = this.playerData.get(player);
        if (serverName == null && VelocityLimboHandler.getDirectConnectServer() != null) {
            serverName = VelocityLimboHandler.getDirectConnectServer().getServerInfo().getName();
        }
        if (serverName == null) {
            return;
        }
        Queue<Player> queue = this.reconnectQueues.get(serverName);
        if (queue != null) {
            queue.remove(player);
        }
    }

    public Player getNextQueuedPlayer(RegisteredServer server) {
        Queue<Player> queue = this.reconnectQueues.get(server.getServerInfo().getName());
        return queue == null ? null : queue.peek();
    }

    public boolean hasQueuedPlayers(RegisteredServer server) {
        Queue<Player> queue = this.reconnectQueues.get(server.getServerInfo().getName());
        return queue != null && !queue.isEmpty();
    }

    public int getQueuePosition(Player player) {
        RegisteredServer server = this.getPreviousServer(player);
        Queue<Player> queue = this.reconnectQueues.get(server.getServerInfo().getName());
        if (queue == null) {
            return -1;
        }
        int position = 1;
        for (Player p : queue) {
            if (p.equals((Object)player)) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public void addPlayerWithIssue(Player player, String issue) {
        this.playerConnectionIssues.put(player.getUniqueId(), issue);
    }

    public boolean hasConnectionIssue(Player player) {
        return this.playerConnectionIssues.containsKey(player.getUniqueId());
    }

    public String getConnectionIssue(Player player) {
        return this.playerConnectionIssues.get(player.getUniqueId());
    }

    public void removePlayerIssue(Player player) {
        this.playerConnectionIssues.remove(player.getUniqueId());
    }

    public void pruneInactivePlayers() {
        for (Queue<Player> queue : this.reconnectQueues.values()) {
            queue.removeIf(p -> !p.isActive());
        }
        this.playerData.keySet().removeIf(p -> !p.isActive());
    }

    public static Player findFirstMaintenanceAllowedPlayer(RegisteredServer server) {
        Queue<Player> queue = VelocityLimboHandler.getPlayerManager().reconnectQueues.get(server.getServerInfo().getName());
        if (queue == null) {
            return null;
        }
        for (Player player : queue) {
            if (!player.hasPermission("maintenance.admin") && !player.hasPermission("maintenance.bypass") && !player.hasPermission("maintenance.singleserver.bypass." + server.getServerInfo().getName()) && !Utility.playerMaintenanceWhitelisted(player)) continue;
            return player;
        }
        return null;
    }

    public boolean isPlayerConnecting(Player player) {
        return this.connectingPlayers.containsKey(player);
    }

    public void setPlayerConnecting(Player player, Boolean add) {
        if (add.booleanValue()) {
            this.connectingPlayers.put(player, true);
        } else {
            this.connectingPlayers.remove(player);
        }
    }
}

