/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler.misc;

import com.akselglyholt.velocityLimboHandler.VelocityLimboHandler;
import com.akselglyholt.velocityLimboHandler.libs.route.Route;
import com.akselglyholt.velocityLimboHandler.misc.MessageFormatter;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utility {
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final String welcomeMsg = VelocityLimboHandler.getMessageConfig().getString(Route.from((Object)"welcomeMessage"));

    public static boolean doServerNamesMatch(@NotNull RegisteredServer var0, @NotNull RegisteredServer var1) {
        return var0.getServerInfo().getName().equals(var1.getServerInfo().getName());
    }

    public static void sendWelcomeMessage(Player player, String reason) {
        if (reason == null) {
            reason = "unknown";
        }
        Component message = switch (reason.toLowerCase()) {
            case "afk" -> miniMessage.deserialize((Object)"<yellow>\u23f3 You were inactive for too long and moved to Limbo.</yellow>\n<gray>You will be reconnected when you interact with the game.</gray>");
            case "server-restart" -> miniMessage.deserialize((Object)"<red>\ud83d\udd04 The server is restarting, so you have been moved to Limbo.</red>\n<gray>You will be reconnected automatically when the server is back.</gray>");
            case "connection-issue" -> miniMessage.deserialize((Object)"<dark_red>\u26a0 You had connection issues and were placed in Limbo.</dark_red>\n<gray>Try reconnecting or wait for a stable connection.</gray>");
            default -> miniMessage.deserialize((Object)MessageFormatter.formatMessage(welcomeMsg, player));
        };
        player.sendMessage(message);
    }

    @Nullable
    public static RegisteredServer getServerByName(String serverName) {
        Optional optionalServer = VelocityLimboHandler.getProxyServer().getServer(serverName);
        if (optionalServer.isPresent()) {
            return (RegisteredServer)optionalServer.get();
        }
        VelocityLimboHandler.getLogger().severe(String.format("Server \"%s\" is invalid, VelocityLimboHandler will not function!", serverName));
        return null;
    }

    public static void logInformational(String message) {
        VelocityLimboHandler.getLogger().info(message);
    }

    public static boolean hasMaintenance() {
        return VelocityLimboHandler.hasMaintenancePlugin();
    }

    public static boolean isServerInMaintenance(String serverName) {
        if (!Utility.hasMaintenance()) {
            return false;
        }
        Object maintenanceAPI = VelocityLimboHandler.getMaintenanceAPI();
        if (maintenanceAPI == null) {
            return false;
        }
        try {
            boolean globalMaintenance = (Boolean)maintenanceAPI.getClass().getMethod("isMaintenance", new Class[0]).invoke(maintenanceAPI, new Object[0]);
            if (globalMaintenance) {
                return true;
            }
        }
        catch (Exception globalMaintenance) {
            // empty catch block
        }
        try {
            try {
                boolean result = (Boolean)maintenanceAPI.getClass().getMethod("isMaintenance", String.class).invoke(maintenanceAPI, serverName);
                return result;
            }
            catch (NoSuchMethodException result) {
                Method[] methods;
                Object server = maintenanceAPI.getClass().getMethod("getServer", String.class).invoke(maintenanceAPI, serverName);
                if (server == null) {
                    return false;
                }
                Class<?> apiClass = maintenanceAPI.getClass();
                for (Method method : methods = apiClass.getMethods()) {
                    Class<?> paramType;
                    if (!method.getName().equals("isMaintenance") || method.getParameterCount() != 1 || !(paramType = method.getParameterTypes()[0]).isAssignableFrom(server.getClass())) continue;
                    boolean result2 = (Boolean)method.invoke(maintenanceAPI, server);
                    return result2;
                }
                return false;
            }
        }
        catch (Exception ex) {
            try {
                VelocityLimboHandler.getLogger().info("Server-specific maintenance check failed for '" + serverName + "': " + ex.getMessage());
                return false;
            }
            catch (Exception e) {
                VelocityLimboHandler.getLogger().warning("Failed to check maintenance status for server '" + serverName + "': " + e.getMessage());
                return false;
            }
        }
    }

    public static boolean playerMaintenanceWhitelisted(Player player) {
        if (!Utility.hasMaintenance()) {
            return false;
        }
        try {
            Object maintenanceAPI = VelocityLimboHandler.getMaintenanceAPI();
            if (maintenanceAPI == null) {
                return false;
            }
            Object settings = maintenanceAPI.getClass().getMethod("getSettings", new Class[0]).invoke(maintenanceAPI, new Object[0]);
            if (settings == null) {
                return false;
            }
            Method getWhitelistedPlayersMethod = settings.getClass().getMethod("getWhitelistedPlayers", new Class[0]);
            Object whitelistMapObj = getWhitelistedPlayersMethod.invoke(settings, new Object[0]);
            if (!(whitelistMapObj instanceof Map)) {
                return false;
            }
            Map whitelistedPlayers = (Map)whitelistMapObj;
            return whitelistedPlayers.containsKey(player.getUniqueId());
        }
        catch (Exception e) {
            VelocityLimboHandler.getLogger().warning("Failed to check if player is whitelisted in Maintenance plugin: " + e.getMessage());
            return false;
        }
    }
}

