/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler.listeners;

import com.akselglyholt.velocityLimboHandler.VelocityLimboHandler;
import com.akselglyholt.velocityLimboHandler.misc.Utility;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.net.InetSocketAddress;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConnectionListener {
    @Subscribe
    public void onPlayerPreConnect(@NotNull ServerPreConnectEvent event) {
        RegisteredServer limbo;
        Player player = event.getPlayer();
        RegisteredServer intendedServer = event.getOriginalServer();
        if (Utility.doServerNamesMatch(intendedServer, limbo = VelocityLimboHandler.getLimboServer())) {
            return;
        }
        if (VelocityLimboHandler.getPlayerManager().isPlayerConnecting(player)) {
            return;
        }
        if (VelocityLimboHandler.getPlayerManager().hasQueuedPlayers(intendedServer)) {
            event.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)limbo));
            VelocityLimboHandler.getLogger().info(String.format("Rerouting %s to Limbo (Server %s is queued)", player.getUsername(), intendedServer.getServerInfo().getName()));
        }
    }

    @Subscribe
    public void onPlayerPostConnect(@NotNull ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        RegisteredServer limbo = VelocityLimboHandler.getLimboServer();
        RegisteredServer currentServer = player.getCurrentServer().map(ServerConnection::getServer).orElse(null);
        RegisteredServer previousServer = event.getPreviousServer();
        if (currentServer == null) {
            VelocityLimboHandler.getLogger().severe(String.format("Current server was null for %s.", player.getUsername()));
            return;
        }
        if (previousServer != null && Utility.doServerNamesMatch(previousServer, limbo)) {
            VelocityLimboHandler.getPlayerManager().removePlayer(player);
            return;
        }
        if (Utility.doServerNamesMatch(currentServer, limbo)) {
            List forcedServers;
            String virtualHost = player.getVirtualHost().map(InetSocketAddress::getHostName).orElse(null);
            RegisteredServer intendedTarget = null;
            if (virtualHost != null && (forcedServers = (List)VelocityLimboHandler.getProxyServer().getConfiguration().getForcedHosts().get(virtualHost)) != null && !forcedServers.isEmpty()) {
                intendedTarget = VelocityLimboHandler.getProxyServer().getServer((String)forcedServers.get(0)).orElse(null);
            }
            if (intendedTarget == null) {
                intendedTarget = previousServer != null ? previousServer : VelocityLimboHandler.getDirectConnectServer();
            }
            VelocityLimboHandler.getPlayerManager().addPlayer(player, intendedTarget);
        }
    }

    @Subscribe
    public void onDisconnect(@NotNull DisconnectEvent event) {
        Player player = event.getPlayer();
        VelocityLimboHandler.getPlayerManager().removePlayer(player);
        VelocityLimboHandler.getPlayerManager().removePlayerIssue(player);
        VelocityLimboHandler.getReconnectBlocker().unblock(player.getUniqueId());
    }
}

