/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler;

import com.akselglyholt.velocityLimboHandler.auth.AuthManager;
import com.akselglyholt.velocityLimboHandler.charts.SingleLineChart;
import com.akselglyholt.velocityLimboHandler.commands.CommandBlockRule;
import com.akselglyholt.velocityLimboHandler.commands.CommandBlocker;
import com.akselglyholt.velocityLimboHandler.libs.YamlDocument;
import com.akselglyholt.velocityLimboHandler.libs.dvs.versioning.BasicVersioning;
import com.akselglyholt.velocityLimboHandler.libs.route.Route;
import com.akselglyholt.velocityLimboHandler.libs.settings.dumper.DumperSettings;
import com.akselglyholt.velocityLimboHandler.libs.settings.general.GeneralSettings;
import com.akselglyholt.velocityLimboHandler.libs.settings.loader.LoaderSettings;
import com.akselglyholt.velocityLimboHandler.libs.settings.updater.UpdaterSettings;
import com.akselglyholt.velocityLimboHandler.listeners.CommandExecuteEventListener;
import com.akselglyholt.velocityLimboHandler.listeners.ConnectionListener;
import com.akselglyholt.velocityLimboHandler.misc.InMemoryReconnectBlocker;
import com.akselglyholt.velocityLimboHandler.misc.MessageFormatter;
import com.akselglyholt.velocityLimboHandler.misc.ReconnectBlocker;
import com.akselglyholt.velocityLimboHandler.misc.Utility;
import com.akselglyholt.velocityLimboHandler.storage.PlayerManager;
import com.akselglyholt.velocityLimboHandler.velocity.Metrics;
import com.google.inject.Inject;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

@Plugin(id="velocity-limbo-handler", name="VelocityLimboHandler", authors={"Aksel Glyholt"}, version="1.7.0")
public class VelocityLimboHandler {
    private static VelocityLimboHandler instance;
    private static ProxyServer proxyServer;
    private static Logger logger;
    private static RegisteredServer limboServer;
    private static RegisteredServer directConnectServer;
    private static PlayerManager playerManager;
    private static CommandBlocker commandBlocker;
    private static ReconnectBlocker reconnectBlocker;
    private static AuthManager authManager;
    private static YamlDocument config;
    private static YamlDocument messageConfig;
    private static boolean queueEnabled;
    private static final MiniMessage miniMessage;
    private static boolean maintenancePluginPresent;
    private static Object maintenanceAPI;
    private final Metrics.Factory metricsFactory;
    private Metrics metrics;
    private static String bannedMsg;
    private static String whitelistedMsg;
    private static String maintenanceModeMsg;
    private static String queuePositionMsg;

    @Inject
    public VelocityLimboHandler(ProxyServer server, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactoryInstance) {
        proxyServer = server;
        instance = this;
        try {
            config = YamlDocument.create(new File(dataDirectory.toFile(), "config.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/config.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build());
            messageConfig = YamlDocument.create(new File(dataDirectory.toFile(), "messages.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/messages.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build());
            config.update();
            config.save();
            messageConfig.update();
            messageConfig.save();
            bannedMsg = messageConfig.getString(Route.from((Object)"bannedMessage"));
            whitelistedMsg = messageConfig.getString(Route.from((Object)"notWhitelisted"));
            maintenanceModeMsg = messageConfig.getString(Route.from((Object)"maintenanceMode"));
            queuePositionMsg = messageConfig.getString(Route.from((Object)"queuePosition"));
        }
        catch (IOException e) {
            logger.severe("Something went wrong while trying to update/create config: " + String.valueOf(e));
            logger.severe("Plugin will now shut down!");
            Optional container = proxyServer.getPluginManager().getPlugin("velocity-limbo-handler");
            container.ifPresent(pluginContainer -> pluginContainer.getExecutorService().shutdown());
        }
        playerManager = new PlayerManager();
        commandBlocker = new CommandBlocker();
        this.metricsFactory = metricsFactoryInstance;
        reconnectBlocker = new InMemoryReconnectBlocker();
        this.initializeMaintenanceIntegration();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        int pluginId = 26682;
        this.metrics = this.metricsFactory.make(this, pluginId);
        this.metrics.addCustomChart(new SingleLineChart("players_in_limbo", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return limboServer != null ? limboServer.getPlayersConnected().size() : 0;
            }
        }));
        authManager = new AuthManager(this, proxyServer, reconnectBlocker);
    }

    private void initializeMaintenanceIntegration() {
        Optional maintenancePlugin = proxyServer.getPluginManager().getPlugin("maintenance");
        if (maintenancePlugin.isPresent()) {
            try {
                Class<?> providerClass = Class.forName("eu.kennytv.maintenance.api.MaintenanceProvider");
                maintenanceAPI = providerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                maintenancePluginPresent = true;
                logger.info("Maintenance plugin detected and integrated successfully.");
            }
            catch (Exception e) {
                logger.warning("Failed to integrate with Maintenance plugin: " + e.getMessage());
                maintenancePluginPresent = false;
                maintenanceAPI = null;
            }
        } else {
            logger.info("Maintenance plugin not detected - maintenance checks disabled.");
        }
    }

    public static boolean hasMaintenancePlugin() {
        return maintenancePluginPresent;
    }

    public static Object getMaintenanceAPI() {
        return maintenanceAPI;
    }

    public static RegisteredServer getLimboServer() {
        return limboServer;
    }

    public static RegisteredServer getDirectConnectServer() {
        return directConnectServer;
    }

    public static ProxyServer getProxyServer() {
        return proxyServer;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static PlayerManager getPlayerManager() {
        return playerManager;
    }

    public static YamlDocument getConfig() {
        return config;
    }

    public static YamlDocument getMessageConfig() {
        return messageConfig;
    }

    public static AuthManager getAuthManager() {
        return authManager;
    }

    @Subscribe
    public void onInitialize(ProxyInitializeEvent event) {
        logger.info("Loading Limbo Handler!");
        EventManager eventManger = proxyServer.getEventManager();
        String limboName = config.getString(Route.from((Object)"limbo-name"));
        String directConnectName = config.getString(Route.from((Object)"direct-connect-server"));
        limboServer = Utility.getServerByName(limboName);
        directConnectServer = Utility.getServerByName(directConnectName);
        if (limboServer == null || directConnectServer == null) {
            eventManger.unregisterListeners((Object)this);
            return;
        }
        eventManger.register((Object)this, (Object)new ConnectionListener());
        eventManger.register((Object)this, (Object)new CommandExecuteEventListener(commandBlocker));
        int reconnectInterval = config.getInt(Route.from((Object)"task-interval"));
        int queueInterval = config.getInt(Route.from((Object)"queue-notify-interval"));
        queueEnabled = config.getBoolean(Route.from((Object)"queue-enabled"), (Boolean)true);
        VelocityLimboHandler.getLogger().info("Queue Enabled: " + queueEnabled);
        List<String> disabledCommands = config.getStringList("disabled-commands");
        for (String cmd : disabledCommands) {
            commandBlocker.blockCommand(cmd, CommandBlockRule.onServer(limboName));
        }
        proxyServer.getScheduler().buildTask((Object)this, () -> {
            Collection connectedPlayers = limboServer.getPlayersConnected();
            if (connectedPlayers.isEmpty()) {
                return;
            }
            playerManager.pruneInactivePlayers();
            if (queueEnabled) {
                for (RegisteredServer server : proxyServer.getAllServers()) {
                    if (!playerManager.hasQueuedPlayers(server)) continue;
                    if (Utility.isServerInMaintenance(server.getServerInfo().getName())) {
                        Player whitelistedPlayer = PlayerManager.findFirstMaintenanceAllowedPlayer(server);
                        if (whitelistedPlayer == null || !whitelistedPlayer.isActive()) continue;
                        VelocityLimboHandler.reconnectPlayer(whitelistedPlayer);
                        continue;
                    }
                    Player nextPlayer = playerManager.getNextQueuedPlayer(server);
                    VelocityLimboHandler.reconnectPlayer(nextPlayer);
                }
            } else {
                for (Player player : connectedPlayers) {
                    RegisteredServer previousServer;
                    if (playerManager.hasConnectionIssue(player) || !player.isActive() || Utility.isServerInMaintenance((previousServer = playerManager.getPreviousServer(player)).getServerInfo().getName()) && (player.hasPermission("maintenance.admin") || player.hasPermission("maintenance.bypass") || player.hasPermission("maintenance.singleserver.bypass." + previousServer.getServerInfo().getName()) || Utility.playerMaintenanceWhitelisted(player) || authManager.isAuthBlocked(player))) continue;
                    VelocityLimboHandler.reconnectPlayer(player);
                    break;
                }
            }
        }).repeat((long)reconnectInterval, TimeUnit.MILLISECONDS).schedule();
        proxyServer.getScheduler().buildTask((Object)this, () -> {
            for (Player player : limboServer.getPlayersConnected()) {
                int position;
                if (playerManager.hasConnectionIssue(player)) {
                    String issue = playerManager.getConnectionIssue(player);
                    if ("banned".equals(issue)) {
                        String formatedMsg = MessageFormatter.formatMessage(bannedMsg, player);
                        player.sendMessage(miniMessage.deserialize((Object)formatedMsg));
                        continue;
                    }
                    if (!"not_whitelisted".equals(issue)) continue;
                    String formatedMsg = MessageFormatter.formatMessage(whitelistedMsg, player);
                    player.sendMessage(miniMessage.deserialize((Object)formatedMsg));
                    continue;
                }
                RegisteredServer previousServer = playerManager.getPreviousServer(player);
                if (Utility.isServerInMaintenance(previousServer.getServerInfo().getName())) {
                    String formatedMsg = MessageFormatter.formatMessage(maintenanceModeMsg, player);
                    player.sendMessage(miniMessage.deserialize((Object)formatedMsg));
                    return;
                }
                if (!queueEnabled || (position = playerManager.getQueuePosition(player)) == -1) continue;
                String formatedQueuePositionMsg = MessageFormatter.formatMessage(queuePositionMsg, player);
                player.sendMessage(miniMessage.deserialize((Object)formatedQueuePositionMsg));
            }
        }).repeat((long)queueInterval, TimeUnit.SECONDS).schedule();
    }

    public static boolean isQueueEnabled() {
        return queueEnabled;
    }

    private static void reconnectPlayer(Player player) {
        if (player == null || !player.isActive()) {
            return;
        }
        if (authManager.isAuthBlocked(player)) {
            return;
        }
        RegisteredServer previousServer = playerManager.getPreviousServer(player);
        previousServer.ping().whenComplete((ping, throwable) -> {
            int onlinePlayers;
            if (throwable != null || ping == null) {
                return;
            }
            if (ping.getPlayers().isEmpty()) {
                return;
            }
            ServerPing.Players serverPlayers = (ServerPing.Players)ping.getPlayers().get();
            int maxPlayers = serverPlayers.getMax();
            if (maxPlayers <= (onlinePlayers = serverPlayers.getOnline())) {
                return;
            }
            if (Utility.isServerInMaintenance(previousServer.getServerInfo().getName())) {
                if (player.hasPermission("maintenance.admin") || player.hasPermission("maintenance.bypass") || player.hasPermission("maintenance.singleserver.bypass." + previousServer.getServerInfo().getName()) || Utility.playerMaintenanceWhitelisted(player)) {
                    logger.info("[Maintenance Bypass] " + player.getUsername() + " bypassed queue to join " + previousServer.getServerInfo().getName());
                } else {
                    return;
                }
            }
            if (playerManager.isPlayerConnecting(player)) {
                return;
            }
            playerManager.setPlayerConnecting(player, true);
            Utility.logInformational(String.format("Connecting %s to %s", player.getUsername(), previousServer.getServerInfo().getName()));
            player.createConnectionRequest(previousServer).connect().whenComplete((result, connectionThrowable) -> {
                playerManager.setPlayerConnecting(player, false);
                if (result.isSuccessful()) {
                    Utility.logInformational(String.format("Successfully reconnected %s to %s", player.getUsername(), previousServer.getServerInfo().getName()));
                    playerManager.removePlayerIssue(player);
                    return;
                }
                if (result.getStatus() == ConnectionRequestBuilder.Status.CONNECTION_IN_PROGRESS) {
                    return;
                }
                Utility.logInformational(String.format("Connection failed for %s to %s. Result status: %s", player.getUsername(), previousServer.getServerInfo().getName(), result.getStatus()));
                if (connectionThrowable != null) {
                    String combinedErrorMessage;
                    String errorMessage = connectionThrowable.getMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    String reasonFromComponent = "";
                    if (result.getReasonComponent().isPresent()) {
                        reasonFromComponent = PlainTextComponentSerializer.plainText().serialize((Component)result.getReasonComponent().get());
                    }
                    if (VelocityLimboHandler.playerConnectIssue(player, combinedErrorMessage = (errorMessage + " " + reasonFromComponent).toLowerCase())) {
                        return;
                    }
                    player.sendMessage(miniMessage.deserialize((Object)("<red>\u274c Failed to connect: " + (errorMessage.isEmpty() ? reasonFromComponent : errorMessage) + "</red>")));
                } else {
                    Optional reasonComponent = result.getReasonComponent();
                    if (reasonComponent.isPresent()) {
                        String reason = PlainTextComponentSerializer.plainText().serialize((Component)reasonComponent.get()).toLowerCase();
                        if (VelocityLimboHandler.playerConnectIssue(player, reason)) {
                            return;
                        }
                        player.sendMessage(miniMessage.deserialize((Object)("<red>\u274c Failed to connect: " + reason + "</red>")));
                    }
                }
            });
        });
    }

    private static boolean playerConnectIssue(Player player, String reason) {
        if (reason.contains("ban") || reason.contains("banned")) {
            String formattedMsg = MessageFormatter.formatMessage(bannedMsg, player);
            player.sendMessage(miniMessage.deserialize((Object)formattedMsg));
            playerManager.addPlayerWithIssue(player, "banned");
            playerManager.removePlayerFromQueue(player);
            return true;
        }
        if (reason.contains("whitelist") || reason.contains("not whitelisted")) {
            String formattedMsg = MessageFormatter.formatMessage(whitelistedMsg, player);
            player.sendMessage(miniMessage.deserialize((Object)formattedMsg));
            playerManager.addPlayerWithIssue(player, "not_whitelisted");
            playerManager.removePlayerFromQueue(player);
            return true;
        }
        return false;
    }

    public static VelocityLimboHandler getInstance() {
        return instance;
    }

    public static ReconnectBlocker getReconnectBlocker() {
        return reconnectBlocker;
    }

    static {
        logger = Logger.getLogger("Limbo Handler");
        miniMessage = MiniMessage.miniMessage();
        maintenancePluginPresent = false;
        maintenanceAPI = null;
    }
}

