/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.velocityLimboHandler.listeners;

import com.akselglyholt.velocityLimboHandler.commands.CommandBlockRule;
import com.akselglyholt.velocityLimboHandler.commands.CommandBlocker;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class CommandExecuteEventListener {
    private final CommandBlocker commandBlocker;

    public CommandExecuteEventListener(CommandBlocker commandBlocker) {
        this.commandBlocker = commandBlocker;
    }

    @Subscribe
    public void onCommandExecute(CommandExecuteEvent event) {
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        Optional serverConnection = player.getCurrentServer();
        if (serverConnection.isPresent()) {
            String command = event.getCommand();
            String commandName = command.split(" ")[0].toLowerCase();
            CommandBlockRule rule = this.commandBlocker.getCommandRules().get(commandName);
            if (rule != null && rule.shouldBlock(player)) {
                event.setResult(CommandExecuteEvent.CommandResult.denied());
                player.sendMessage(Component.text((String)"Commands are disabled on this server!").color((TextColor)NamedTextColor.RED));
            }
        }
    }
}

