/*
 * Decompiled with CFR 0.152.
 */
package com.adityapokuri.recipeViewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RecipeViewer
extends JavaPlugin
implements CommandExecutor,
TabCompleter,
Listener {
    private final Map<UUID, Integer> playerPageMap = new HashMap<UUID, Integer>();
    private final Map<UUID, List<Inventory>> playerRecipePages = new HashMap<UUID, List<Inventory>>();
    private static final Material[] WOOD_PLANKS = new Material[]{Material.OAK_PLANKS, Material.SPRUCE_PLANKS, Material.BIRCH_PLANKS, Material.JUNGLE_PLANKS, Material.ACACIA_PLANKS, Material.DARK_OAK_PLANKS, Material.MANGROVE_PLANKS, Material.CHERRY_PLANKS, Material.BAMBOO_PLANKS, Material.CRIMSON_PLANKS, Material.WARPED_PLANKS};

    public void onEnable() {
        this.getCommand("recipe").setExecutor((CommandExecutor)this);
        this.getCommand("recipe").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (!this.hasCharcoalTorchRecipe()) {
            ShapelessRecipe charcoalTorch = new ShapelessRecipe(new NamespacedKey((Plugin)this, "torch_charcoal"), new ItemStack(Material.TORCH, 4));
            charcoalTorch.addIngredient(Material.STICK);
            charcoalTorch.addIngredient(Material.CHARCOAL);
            Bukkit.addRecipe((Recipe)charcoalTorch);
            this.getLogger().info("Added missing recipe for Charcoal Torch.");
        }
        this.addWoodTypeRecipes();
    }

    private boolean hasCharcoalTorchRecipe() {
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe recipe = (Recipe)recipeIterator.next();
            if (recipe.getResult().getType() != Material.TORCH || !(recipe instanceof ShapelessRecipe)) continue;
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            for (ItemStack item : shapeless.getIngredientList()) {
                if (item == null || item.getType() != Material.CHARCOAL) continue;
                return true;
            }
        }
        return false;
    }

    private void addWoodTypeRecipes() {
        ShapedRecipe recipe;
        String keyName;
        for (Material plank : WOOD_PLANKS) {
            keyName = "crafting_table_" + plank.name().toLowerCase();
            recipe = new ShapedRecipe(new NamespacedKey((Plugin)this, keyName), new ItemStack(Material.CRAFTING_TABLE));
            recipe.shape(new String[]{"##", "##"});
            recipe.setIngredient('#', plank);
            Bukkit.addRecipe((Recipe)recipe);
        }
        for (Material plank : WOOD_PLANKS) {
            keyName = "stick_" + plank.name().toLowerCase();
            recipe = new ShapedRecipe(new NamespacedKey((Plugin)this, keyName), new ItemStack(Material.STICK, 4));
            recipe.shape(new String[]{"##", "##"});
            recipe.setIngredient('#', plank);
            Bukkit.addRecipe((Recipe)recipe);
        }
        Material[] wools = new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.GRAY_WOOL, Material.LIGHT_GRAY_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL};
        for (Material plank : WOOD_PLANKS) {
            for (Material wool : wools) {
                String keyName2 = "bed_" + plank.name().toLowerCase() + "_" + wool.name().toLowerCase();
                ShapedRecipe recipe2 = new ShapedRecipe(new NamespacedKey((Plugin)this, keyName2), new ItemStack(Material.getMaterial((String)wool.name().replace("WOOL", "BED"))));
                recipe2.shape(new String[]{"###", "XXX"});
                recipe2.setIngredient('#', plank);
                recipe2.setIngredient('X', wool);
                Bukkit.addRecipe((Recipe)recipe2);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (!title.startsWith("\u00a70Recipe:")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() != Material.ARROW) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String name = meta.getDisplayName();
        UUID uuid = player.getUniqueId();
        int currentPage = this.playerPageMap.getOrDefault(uuid, 0);
        List<Inventory> pages = this.playerRecipePages.get(uuid);
        if ("\u00a7eNext Page".equals(name) && currentPage + 1 < pages.size()) {
            this.playerPageMap.put(uuid, currentPage + 1);
            int newPage = currentPage + 1;
            this.updatePageTitle(player, pages.get(newPage), newPage, pages.size(), title.replaceFirst("\\s\\(Page \\d+/\\d+\\)?", ""));
            player.openInventory(pages.get(newPage));
        } else if ("\u00a7ePrevious Page".equals(name) && currentPage - 1 >= 0) {
            this.playerPageMap.put(uuid, currentPage - 1);
            int newPage = currentPage - 1;
            this.updatePageTitle(player, pages.get(newPage), newPage, pages.size(), title.replaceFirst("\\s\\(Page \\d+/\\d+\\)?", ""));
            player.openInventory(pages.get(newPage));
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getView().getTitle().startsWith("\u00a70Recipe:")) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Object smithingPage;
        Inventory page;
        String recipeKey;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u001b[31m\u001b[1m[RecipeViewer]\u001b[0m \u001b[31mError: The /recipe command can only be used by a player.\u001b[0m");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage("\u00a7c\u00a7l[RecipeViewer] \u00a7cUsage: /recipe <item>");
            return true;
        }
        Material material = Material.matchMaterial((String)args[0].toUpperCase());
        if (material == null) {
            player.sendMessage("\u00a7c\u00a7l[RecipeViewer] \u00a7cThis item does not exist");
            return true;
        }
        ArrayList<Inventory> pages = new ArrayList<Inventory>();
        HashSet<String> recipeKeys = new HashSet<String>();
        for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)new ItemStack(material))) {
            recipeKey = this.getRecipeKey(recipe);
            if (!recipeKeys.add(recipeKey) || (page = this.createRecipePage(recipe, material)) == null) continue;
            pages.add(page);
        }
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe recipe;
            recipe = (Recipe)recipeIterator.next();
            if (recipe.getResult().getType() != material || !(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe) && !(recipe instanceof FurnaceRecipe) && !(recipe instanceof StonecuttingRecipe) || !recipeKeys.add(recipeKey = this.getRecipeKey(recipe)) || (page = this.createRecipePage(recipe, material)) == null) continue;
            pages.add(page);
        }
        if (this.isNetheriteToolOrArmor(material) && (smithingPage = this.createSmithingPage(material)) != null) {
            pages.add((Inventory)smithingPage);
        }
        if (pages.isEmpty()) {
            player.sendMessage("\u00a7c\u00a7l[RecipeViewer] \u00a7cThe Item \u00a7n" + this.toCamelCase(material.name().toLowerCase().replace('_', ' ')) + "\u00a7c is not craftable");
            return true;
        }
        if (pages.size() > 1) {
            for (Inventory page2 : pages) {
                ItemStack next = new ItemStack(Material.ARROW);
                ItemMeta meta = next.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName("\u00a7eNext Page");
                    next.setItemMeta(meta);
                }
                page2.setItem(26, next);
                ItemStack prev = new ItemStack(Material.ARROW);
                meta = prev.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName("\u00a7ePrevious Page");
                    prev.setItemMeta(meta);
                }
                page2.setItem(18, prev);
            }
        }
        UUID uuid = player.getUniqueId();
        this.playerPageMap.put(uuid, 0);
        this.playerRecipePages.put(uuid, pages);
        this.updatePageTitle(player, (Inventory)pages.get(0), 0, pages.size(), "\u00a70Recipe: " + this.toCamelCase(material.name().toLowerCase().replace('_', ' ')));
        player.openInventory((Inventory)pages.get(0));
        Bukkit.getLogger().info("Found " + pages.size() + " recipes for " + material.name());
        return true;
    }

    private String getRecipeKey(Recipe recipe) {
        StringBuilder key = new StringBuilder(recipe.getClass().getSimpleName());
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            for (String row : shaped.getShape()) {
                key.append(row);
            }
            Map ingredients = shaped.getIngredientMap();
            ingredients.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> key.append(entry.getValue() != null ? ((ItemStack)entry.getValue()).getType().name() : "null"));
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            ArrayList ingredients = new ArrayList(shapeless.getIngredientList());
            ingredients.sort((a, b) -> {
                String aName = a != null ? a.getType().name() : "null";
                String bName = b != null ? b.getType().name() : "null";
                return aName.compareTo(bName);
            });
            for (ItemStack item : ingredients) {
                key.append(item != null ? item.getType().name() : "null");
            }
        } else if (recipe instanceof FurnaceRecipe) {
            FurnaceRecipe furnace = (FurnaceRecipe)recipe;
            key.append(furnace.getInput().getType().name());
        } else if (recipe instanceof StonecuttingRecipe) {
            StonecuttingRecipe stonecutting = (StonecuttingRecipe)recipe;
            key.append(stonecutting.getInput().getType().name());
        }
        return key.toString().hashCode() + "_" + key.toString();
    }

    private boolean isNetheriteToolOrArmor(Material material) {
        return switch (material) {
            case Material.NETHERITE_SWORD, Material.NETHERITE_PICKAXE, Material.NETHERITE_AXE, Material.NETHERITE_SHOVEL, Material.NETHERITE_HOE, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS -> true;
            default -> false;
        };
    }

    private Inventory createSmithingPage(Material result) {
        Material base;
        String baseTitle = "\u00a70Recipe: " + this.toCamelCase(result.name().toLowerCase().replace('_', ' '));
        UUID uuid = ((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId();
        int currentPage = this.playerPageMap.getOrDefault(uuid, 0);
        int totalPages = ((List)this.playerRecipePages.getOrDefault(uuid, new ArrayList())).size();
        String pageInfo = totalPages > 1 ? " (Page " + (currentPage + 1) + "/" + totalPages + ")" : "";
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)(baseTitle + pageInfo));
        for (int i = 0; i < 27; ++i) {
            inventory.setItem(i, this.createFiller());
        }
        switch (result) {
            case NETHERITE_SWORD: {
                Material material = Material.DIAMOND_SWORD;
                break;
            }
            case NETHERITE_PICKAXE: {
                Material material = Material.DIAMOND_PICKAXE;
                break;
            }
            case NETHERITE_AXE: {
                Material material = Material.DIAMOND_AXE;
                break;
            }
            case NETHERITE_SHOVEL: {
                Material material = Material.DIAMOND_SHOVEL;
                break;
            }
            case NETHERITE_HOE: {
                Material material = Material.DIAMOND_HOE;
                break;
            }
            case NETHERITE_HELMET: {
                Material material = Material.DIAMOND_HELMET;
                break;
            }
            case NETHERITE_CHESTPLATE: {
                Material material = Material.DIAMOND_CHESTPLATE;
                break;
            }
            case NETHERITE_LEGGINGS: {
                Material material = Material.DIAMOND_LEGGINGS;
                break;
            }
            case NETHERITE_BOOTS: {
                Material material = Material.DIAMOND_BOOTS;
                break;
            }
            default: {
                Material material = base = null;
            }
        }
        if (base == null) {
            return null;
        }
        inventory.setItem(11, new ItemStack(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE));
        inventory.setItem(12, new ItemStack(base));
        inventory.setItem(13, new ItemStack(Material.NETHERITE_INGOT));
        ItemStack resultItem = new ItemStack(result, 1);
        ItemMeta meta = resultItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7eResult: 1 " + this.toCamelCase(result.name().toLowerCase().replace('_', ' ')));
            resultItem.setItemMeta(meta);
        }
        inventory.setItem(15, resultItem);
        ItemStack table = new ItemStack(Material.SMITHING_TABLE);
        meta = table.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7eUse Smithing Table");
            table.setItemMeta(meta);
        }
        inventory.setItem(8, table);
        return inventory;
    }

    private Inventory createRecipePage(Recipe recipe, Material result) {
        String baseTitle = "\u00a70Recipe: " + this.toCamelCase(result.name().toLowerCase().replace('_', ' '));
        UUID uuid = ((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId();
        int currentPage = this.playerPageMap.getOrDefault(uuid, 0);
        int totalPages = ((List)this.playerRecipePages.getOrDefault(uuid, new ArrayList())).size();
        String pageInfo = totalPages > 1 ? " (Page " + (currentPage + 1) + "/" + totalPages + ")" : "";
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)(baseTitle + pageInfo));
        boolean isCrafting = recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe;
        for (int i = 0; i < 27; ++i) {
            if (isCrafting && (i == 2 || i == 3 || i == 4 || i == 11 || i == 12 || i == 13 || i == 20 || i == 21 || i == 22)) continue;
            inventory.setItem(i, this.createFiller());
        }
        int resultAmount = 1;
        if (recipe instanceof FurnaceRecipe) {
            FurnaceRecipe furnace = (FurnaceRecipe)recipe;
            inventory.setItem(12, furnace.getInput().clone());
            ItemStack furnaceBlock = new ItemStack(Material.FURNACE);
            this.setRecipeLabel(furnaceBlock);
            inventory.setItem(8, furnaceBlock);
            if (this.isFood(result)) {
                ItemStack smokerBlock = new ItemStack(Material.SMOKER);
                this.setRecipeLabel(smokerBlock);
                inventory.setItem(7, smokerBlock);
            } else if (this.isOre(result)) {
                ItemStack blastFurnaceBlock = new ItemStack(Material.BLAST_FURNACE);
                this.setRecipeLabel(blastFurnaceBlock);
                inventory.setItem(7, blastFurnaceBlock);
            }
            resultAmount = furnace.getResult().getAmount();
        } else if (recipe instanceof StonecuttingRecipe) {
            StonecuttingRecipe stonecutting = (StonecuttingRecipe)recipe;
            inventory.setItem(12, stonecutting.getInput().clone());
            ItemStack stonecutter = new ItemStack(Material.STONECUTTER);
            this.setRecipeLabel(stonecutter);
            inventory.setItem(8, stonecutter);
            resultAmount = stonecutting.getResult().getAmount();
        } else if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            Map ingredientMap = shaped.getIngredientMap();
            String[] shape = shaped.getShape();
            int[] slots = new int[]{2, 3, 4, 11, 12, 13, 20, 21, 22};
            for (int row = 0; row < shape.length; ++row) {
                for (int col = 0; col < shape[row].length(); ++col) {
                    ItemStack ingredient;
                    int index = row * 3 + col;
                    if (index >= slots.length || (ingredient = (ItemStack)ingredientMap.get(Character.valueOf(shape[row].charAt(col)))) == null || ingredient.getType() == Material.AIR) continue;
                    inventory.setItem(slots[index], ingredient.clone());
                }
            }
            ItemStack craftingTable = new ItemStack(Material.CRAFTING_TABLE);
            this.setRecipeLabel(craftingTable);
            inventory.setItem(8, craftingTable);
            resultAmount = shaped.getResult().getAmount();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            List ingredients = shapeless.getIngredientList();
            int[] slots = new int[]{2, 3, 4, 11, 12, 13, 20, 21, 22};
            for (int i = 0; i < ingredients.size() && i < slots.length; ++i) {
                ItemStack item = (ItemStack)ingredients.get(i);
                if (item == null || item.getType() == Material.AIR) continue;
                inventory.setItem(slots[i], item.clone());
            }
            ItemStack craftingTable = new ItemStack(Material.CRAFTING_TABLE);
            this.setRecipeLabel(craftingTable);
            inventory.setItem(8, craftingTable);
            resultAmount = shapeless.getResult().getAmount();
        } else {
            return null;
        }
        ItemStack resultItem = new ItemStack(result, resultAmount);
        ItemMeta meta = resultItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7eResult: " + resultAmount + " " + this.toCamelCase(result.name().toLowerCase().replace('_', ' ')));
            resultItem.setItemMeta(meta);
        }
        inventory.setItem(15, resultItem);
        return inventory;
    }

    private void updatePageTitle(Player player, Inventory page, int currentPage, int totalPages, String baseTitle) {
        String newTitle = baseTitle + (String)(totalPages > 1 ? " (Page " + (currentPage + 1) + "/" + totalPages + ")" : "");
        Inventory newInventory = Bukkit.createInventory((InventoryHolder)page.getHolder(), (int)page.getSize(), (String)newTitle);
        newInventory.setContents(page.getContents());
        player.openInventory(newInventory);
        this.playerRecipePages.get(player.getUniqueId()).set(currentPage, newInventory);
    }

    private String toCamelCase(String text) {
        String[] words = text.split(" ");
        StringBuilder camelCase = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            camelCase.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return camelCase.toString().trim();
    }

    private void setRecipeLabel(ItemStack block) {
        ItemMeta meta = block.getItemMeta();
        if (meta != null) {
            String name;
            String label = switch (name = block.getType().name()) {
                case "FURNACE" -> "Use Furnace";
                case "SMOKER" -> "Use Smoker";
                case "BLAST_FURNACE" -> "Use Blast Furnace";
                case "STONECUTTER" -> "Use Stonecutter";
                case "CRAFTING_TABLE" -> "Use Crafting Table";
                case "SMITHING_TABLE" -> "Use Smithing Table";
                default -> name.replace('_', ' ').toLowerCase() + " recipe";
            };
            meta.setDisplayName("\u00a7e" + label);
            block.setItemMeta(meta);
        }
    }

    private boolean isFood(Material material) {
        return material.isEdible();
    }

    private boolean isOre(Material material) {
        String name = material.name();
        return name.endsWith("_INGOT") || name.endsWith("_NUGGET") || name.endsWith("_CRYSTAL") || name.contains("COPPER") || name.contains("RAW_") || name.contains("ORE");
    }

    private ItemStack createFiller() {
        ItemStack filler = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            filler.setItemMeta(meta);
        }
        return filler;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        String input = args[0].toLowerCase();
        HashSet<String> resultItems = new HashSet<String>();
        Iterator iterator = Bukkit.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = (Recipe)iterator.next();
            if (!(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe) && !(recipe instanceof FurnaceRecipe) && !(recipe instanceof StonecuttingRecipe)) continue;
            resultItems.add(recipe.getResult().getType().name().toLowerCase());
        }
        for (Material material : Material.values()) {
            if (!this.isNetheriteToolOrArmor(material)) continue;
            resultItems.add(material.name().toLowerCase());
        }
        return resultItems.stream().filter(name -> name.startsWith(input)).sorted().toList();
    }
}

