/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.retroBedrockTotem;

import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.geysermc.floodgate.api.FloodgateApi;

public class PlayerDamageListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        UUID playerUuid = player.getUniqueId();
        if (!FloodgateApi.getInstance().isFloodgatePlayer(playerUuid)) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack totem = null;
        int totemSlot = -1;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != Material.TOTEM_OF_UNDYING) continue;
            totem = item;
            totemSlot = i;
            break;
        }
        if (totem != null && totemSlot != -1) {
            event.setCancelled(true);
            totem.setAmount(totem.getAmount() - 1);
            inventory.setItem(totemSlot, totem);
            player.setHealth(1.0);
            player.removePotionEffect(PotionEffectType.POISON);
            player.removePotionEffect(PotionEffectType.WITHER);
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 900, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0));
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
            player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation().add(0.0, 1.0, 0.0), 50, 0.5, 0.5, 0.5, 0.1);
        }
    }
}

