/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.utils;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class Messenger {
    private final String prefix;
    private final LegacyComponentSerializer serializer;

    public Messenger(String prefix) {
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)prefix) + " " + String.valueOf(ChatColor.RESET);
        this.serializer = LegacyComponentSerializer.legacyAmpersand();
    }

    public void sendMessage(@NotNull CommandSender sender, String message) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.WHITE) + message);
    }

    public void sendError(@NotNull CommandSender sender, String errorMessage) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + errorMessage);
    }

    public void sendSuccess(@NotNull CommandSender sender, String successMessage) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + successMessage);
    }

    public String componentToString(Component component) {
        return this.serializer.serialize(component);
    }
}

