/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Home;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleportManager {
    private final FoliaCore plugin;
    private final Map<UUID, Map<String, Home>> playerHomes = new ConcurrentHashMap<UUID, Map<String, Home>>();
    private final Map<UUID, ScheduledTask> pendingTeleports = new ConcurrentHashMap<UUID, ScheduledTask>();
    private final Map<UUID, TeleportRequest> pendingTpaRequests = new ConcurrentHashMap<UUID, TeleportRequest>();
    private volatile Location spawnLocation;
    private final File dataFile;
    private FileConfiguration dataConfig;
    private static final long TPA_REQUEST_TIMEOUT_MS = 60000L;
    private static final long TELEPORT_DELAY_TICKS = 60L;

    public TeleportManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "teleport_data.yml");
    }

    public void load() {
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("teleport_data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadHomes();
        this.loadSpawn();
    }

    public void startTeleport(@NotNull Player player, @NotNull Location location, String successMessage) {
        if (this.isTeleporting(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Teleportation already in progress.");
            return;
        }
        this.plugin.getMessenger().sendMessage((CommandSender)player, "Teleporting... Stand still for 3 seconds.");
        ScheduledTask task = player.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> {
            this.pendingTeleports.remove(player.getUniqueId());
            player.teleportAsync(location).thenAccept(result -> {
                if (result.booleanValue()) {
                    this.plugin.getMessenger().sendSuccess((CommandSender)player, successMessage);
                } else {
                    this.plugin.getMessenger().sendError((CommandSender)player, "Teleport failed. Destination may be obstructed.");
                }
            });
        }, null, 60L);
        this.pendingTeleports.put(player.getUniqueId(), task);
    }

    public void cancelTeleport(@NotNull Player player) {
        ScheduledTask task = this.pendingTeleports.remove(player.getUniqueId());
        if (task != null && !task.isCancelled()) {
            task.cancel();
            this.plugin.getMessenger().sendError((CommandSender)player, "Teleport cancelled due to movement.");
        }
    }

    public boolean isTeleporting(UUID uuid) {
        return this.pendingTeleports.containsKey(uuid);
    }

    public void cleanupPlayer(UUID uuid) {
        this.pendingTeleports.remove(uuid);
        this.pendingTpaRequests.remove(uuid);
    }

    public void createTpaRequest(UUID requester, UUID target, TpaType type) {
        this.pendingTpaRequests.put(target, new TeleportRequest(requester, target, type, System.currentTimeMillis()));
    }

    @Nullable
    public TeleportRequest getTpaRequest(UUID target) {
        TeleportRequest request = this.pendingTpaRequests.get(target);
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.timestamp() > 60000L) {
            this.pendingTpaRequests.remove(target);
            return null;
        }
        return request;
    }

    public void removeTpaRequest(UUID target) {
        this.pendingTpaRequests.remove(target);
    }

    public void saveData() {
        HashMap<UUID, Map<String, Home>> homesSnapshot = new HashMap<UUID, Map<String, Home>>(this.playerHomes);
        Location spawnSnapshot = this.spawnLocation;
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            try {
                YamlConfiguration tempConfig = new YamlConfiguration();
                for (Map.Entry entry : homesSnapshot.entrySet()) {
                    String uuid = ((UUID)entry.getKey()).toString();
                    for (Map.Entry homeEntry : ((Map)entry.getValue()).entrySet()) {
                        tempConfig.set("homes." + uuid + "." + (String)homeEntry.getKey(), ((Home)homeEntry.getValue()).serialize());
                    }
                }
                if (spawnSnapshot != null) {
                    tempConfig.set("spawn", (Object)spawnSnapshot.serialize());
                }
                tempConfig.save(this.dataFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save teleport data.");
                e.printStackTrace();
            }
        });
    }

    private void loadHomes() {
        ConfigurationSection homesSection = this.dataConfig.getConfigurationSection("homes");
        if (homesSection == null) {
            return;
        }
        for (String uuidString : homesSection.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                ConfigurationSection playerHomeSection = homesSection.getConfigurationSection(uuidString);
                if (playerHomeSection == null) continue;
                ConcurrentHashMap<String, Home> homes = new ConcurrentHashMap<String, Home>();
                for (String homeName : playerHomeSection.getKeys(false)) {
                    ConfigurationSection homeSection = playerHomeSection.getConfigurationSection(homeName);
                    if (homeSection == null) continue;
                    homes.put(homeName.toLowerCase(), Home.deserialize(homeSection.getValues(false)));
                }
                this.playerHomes.put(playerUUID, homes);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Skipping invalid UUID in homes.yml: " + uuidString);
            }
        }
    }

    private void loadSpawn() {
        ConfigurationSection spawnSection = this.dataConfig.getConfigurationSection("spawn");
        if (spawnSection != null) {
            try {
                this.spawnLocation = Location.deserialize((Map)spawnSection.getValues(false));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to deserialize spawn location.");
            }
        }
    }

    public void setHome(UUID playerUUID, String homeName, Location location) {
        this.playerHomes.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(homeName.toLowerCase(), new Home(location));
        this.saveData();
    }

    @Nullable
    public Home getHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        return homes == null ? null : homes.get(homeName.toLowerCase());
    }

    public void deleteHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        if (homes != null) {
            homes.remove(homeName.toLowerCase());
            this.saveData();
        }
    }

    public int getHomeCount(UUID playerUUID) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        return homes == null ? 0 : homes.size();
    }

    public Map<String, Home> getHomes(UUID playerUUID) {
        return this.playerHomes.getOrDefault(playerUUID, Collections.emptyMap());
    }

    public void setSpawn(Location location) {
        this.spawnLocation = location;
        this.saveData();
    }

    public Location getSpawn() {
        return this.spawnLocation != null ? this.spawnLocation : ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
    }

    public int getMaxHomes(Player player) {
        if (player.hasPermission("foliacore.homes.unlimited")) {
            return Integer.MAX_VALUE;
        }
        int max = 0;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission();
            if (!perm.startsWith("foliacore.homes.")) continue;
            try {
                int num = Integer.parseInt(perm.substring(16));
                max = Math.max(max, num);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max == 0 && player.hasPermission("foliacore.homes.default") ? 1 : max;
    }

    public record TeleportRequest(UUID requester, UUID target, TpaType type, long timestamp) {
    }

    public static enum TpaType {
        TPA,
        TPAHERE;

    }
}

