/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Kit;
import dev.ajaretro.foliaCore.utils.ItemUtil;
import dev.ajaretro.foliaCore.utils.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitManager {
    private static KitManager instance;
    private final FoliaCore plugin;
    private final Map<String, Kit> kits;
    private final Map<UUID, Map<String, Long>> kitCooldowns;
    private File dataFile;
    private FileConfiguration dataConfig;

    public KitManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.kits = new ConcurrentHashMap<String, Kit>();
        this.kitCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    }

    public static KitManager getInstance() {
        return instance;
    }

    public void load() {
        instance = this;
        this.dataFile = new File(this.plugin.getDataFolder(), "kits.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("kits.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadKits();
    }

    private void loadKits() {
        ConfigurationSection kitsSection = this.dataConfig.getConfigurationSection("kits");
        if (kitsSection == null) {
            this.plugin.getLogger().warning("No 'kits' section found in kits.yml!");
            return;
        }
        for (String kitName : kitsSection.getKeys(false)) {
            try {
                ConfigurationSection kitSection = kitsSection.getConfigurationSection(kitName);
                if (kitSection == null) continue;
                Map kitData = kitSection.getValues(false);
                Kit kit = Kit.deserialize(kitName, kitData);
                this.kits.put(kitName.toLowerCase(), kit);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load kit: " + kitName);
                e.printStackTrace();
            }
        }
    }

    public void saveData() {
        try {
            this.dataConfig.set("kits", null);
            for (Map.Entry<String, Kit> entry : this.kits.entrySet()) {
                this.dataConfig.set("kits." + entry.getKey(), entry.getValue().serialize());
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save kit data to file!");
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public Kit getKit(String name) {
        return this.kits.get(name.toLowerCase());
    }

    public Collection<Kit> getAllKits() {
        return this.kits.values();
    }

    public boolean isKit(String name) {
        return this.kits.containsKey(name.toLowerCase());
    }

    public void createKit(String name, long cooldown, String permission, Material displayMaterial, ItemStack[] items) {
        String itemsBase64 = ItemUtil.serializeItems(items);
        Kit kit = new Kit(name, cooldown, permission, displayMaterial, itemsBase64);
        this.kits.put(name.toLowerCase(), kit);
        this.saveDataAsync();
    }

    public void deleteKit(String name) {
        this.kits.remove(name.toLowerCase());
        this.saveDataAsync();
    }

    public boolean isOnCooldown(UUID playerUUID, Kit kit) {
        Map<String, Long> cooldowns = this.kitCooldowns.get(playerUUID);
        if (cooldowns == null) {
            return false;
        }
        Long expiration = cooldowns.get(kit.name().toLowerCase());
        if (expiration == null) {
            return false;
        }
        if (System.currentTimeMillis() < expiration) {
            return true;
        }
        cooldowns.remove(kit.name().toLowerCase());
        return false;
    }

    public void setOnCooldown(UUID playerUUID, Kit kit) {
        long expirationTime = System.currentTimeMillis() + kit.cooldown() * 1000L;
        this.kitCooldowns.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(kit.name().toLowerCase(), expirationTime);
    }

    public long getRemainingCooldown(UUID playerUUID, Kit kit) {
        Map<String, Long> cooldowns = this.kitCooldowns.get(playerUUID);
        if (cooldowns == null) {
            return 0L;
        }
        Long expiration = cooldowns.get(kit.name().toLowerCase());
        if (expiration == null) {
            return 0L;
        }
        long remaining = expiration - System.currentTimeMillis();
        return remaining > 0L ? remaining : 0L;
    }

    public boolean giveKit(Player player, Kit kit) {
        if (!player.hasPermission(kit.permission())) {
            FoliaCore.getInstance().getMessenger().sendError((CommandSender)player, "You do not have permission to use this kit.");
            return false;
        }
        if (this.isOnCooldown(player.getUniqueId(), kit)) {
            long remaining = this.getRemainingCooldown(player.getUniqueId(), kit);
            String formattedTime = TimeUtil.formatDuration(remaining);
            FoliaCore.getInstance().getMessenger().sendError((CommandSender)player, "You must wait " + String.valueOf(ChatColor.GOLD) + formattedTime + String.valueOf(ChatColor.RED) + " before using this kit again.");
            return false;
        }
        for (ItemStack item : kit.getItems()) {
            if (item == null) continue;
            if (player.getInventory().firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
                continue;
            }
            player.getInventory().addItem(new ItemStack[]{item});
        }
        this.setOnCooldown(player.getUniqueId(), kit);
        FoliaCore.getInstance().getMessenger().sendSuccess((CommandSender)player, "You have redeemed the " + String.valueOf(ChatColor.GOLD) + kit.name() + String.valueOf(ChatColor.GREEN) + " kit.");
        return true;
    }
}

