/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.economy.FoliaEconomy;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final FoliaCore plugin;
    private Economy econ = null;
    private File dataFile;
    private FileConfiguration dataConfig;

    public EconomyManager(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public void load() {
        if (!this.setupEconomy()) {
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "===================================================");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "VAULT NOT FOUND! Economy features will be disabled.");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "Please install Vault.");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "===================================================");
            return;
        }
        if (this.econ instanceof FoliaEconomy) {
            this.loadLocalData();
        }
    }

    private boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    private void loadLocalData() {
        this.dataFile = new File(this.plugin.getDataFolder(), "economy.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("economy.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        HashMap<String, Double> loadedBalances = new HashMap<String, Double>();
        if (this.dataConfig.contains("balances")) {
            for (String uuid : this.dataConfig.getConfigurationSection("balances").getKeys(false)) {
                double amount = this.dataConfig.getDouble("balances." + uuid);
                loadedBalances.put(uuid, amount);
            }
        }
        ((FoliaEconomy)this.econ).setBalances(loadedBalances);
        this.plugin.getLogger().info("Loaded " + loadedBalances.size() + " accounts into FoliaEconomy.");
    }

    public void saveData() {
        if (!(this.econ instanceof FoliaEconomy)) {
            return;
        }
        if (this.dataFile == null || this.dataConfig == null) {
            return;
        }
        Map<String, Double> balances = ((FoliaEconomy)this.econ).getBalances();
        this.dataConfig.set("balances", null);
        for (Map.Entry<String, Double> entry : balances.entrySet()) {
            this.dataConfig.set("balances." + entry.getKey(), (Object)entry.getValue());
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save economy data!");
            e.printStackTrace();
        }
    }

    public boolean hasEconomy() {
        return this.econ != null;
    }

    public String format(double amount) {
        return this.econ.format(amount);
    }

    public double getBalance(OfflinePlayer player) {
        return this.econ.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.econ.has(player, amount);
    }

    public EconomyResponse withdraw(OfflinePlayer player, double amount) {
        EconomyResponse response = this.econ.withdrawPlayer(player, amount);
        if (this.econ instanceof FoliaEconomy && response.transactionSuccess()) {
            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
        }
        return response;
    }

    public EconomyResponse deposit(OfflinePlayer player, double amount) {
        EconomyResponse response = this.econ.depositPlayer(player, amount);
        if (this.econ instanceof FoliaEconomy && response.transactionSuccess()) {
            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
        }
        return response;
    }
}

