/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.ChatMode;
import dev.ajaretro.foliaCore.data.Mail;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ChatManager {
    private static ChatManager instance;
    private final FoliaCore plugin;
    private final ConcurrentHashMap<UUID, Long> mutes;
    private final ConcurrentHashMap<UUID, UUID> replyTargets;
    private final ConcurrentHashMap<UUID, Set<UUID>> blockedPlayers;
    private final ConcurrentHashMap<UUID, List<Mail>> mailboxes;
    private final ConcurrentHashMap<UUID, ChatMode> playerChatModes;
    private final ConcurrentHashMap<UUID, String> nicknames;
    private File dataFile;
    private FileConfiguration dataConfig;
    private boolean chatRangesEnabled;
    private ChatMode defaultMode;
    private int regionalRadius;
    private String globalPrefix;
    private String chatFormat;

    public ChatManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.mutes = new ConcurrentHashMap();
        this.replyTargets = new ConcurrentHashMap();
        this.blockedPlayers = new ConcurrentHashMap();
        this.mailboxes = new ConcurrentHashMap();
        this.playerChatModes = new ConcurrentHashMap();
        this.nicknames = new ConcurrentHashMap();
    }

    public static ChatManager getInstance() {
        return instance;
    }

    public void load() {
        instance = this;
        this.dataFile = new File(this.plugin.getDataFolder(), "chat_data.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("chat_data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadConfigSettings();
        this.loadMutes();
        this.loadBlockedPlayers();
        this.loadMail();
        this.loadNicknames();
    }

    private void loadConfigSettings() {
        this.chatRangesEnabled = this.dataConfig.getBoolean("chat-settings.enabled", true);
        try {
            this.defaultMode = ChatMode.valueOf(this.dataConfig.getString("chat-settings.default-mode", "GLOBAL").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.defaultMode = ChatMode.GLOBAL;
        }
        this.regionalRadius = this.dataConfig.getInt("chat-settings.regional-chat-radius", 100);
        this.globalPrefix = this.dataConfig.getString("chat-settings.global-chat-prefix", "!");
        this.chatFormat = this.dataConfig.getString("chat-settings.format", "<{DISPLAYNAME}> {MESSAGE}");
    }

    private void loadMutes() {
        ConfigurationSection mutesSection = this.dataConfig.getConfigurationSection("mutes");
        if (mutesSection == null) {
            return;
        }
        for (String key : mutesSection.getKeys(false)) {
            try {
                this.mutes.put(UUID.fromString(key), this.dataConfig.getLong("mutes." + key));
            }
            catch (Exception exception) {}
        }
    }

    private void loadBlockedPlayers() {
        ConfigurationSection blockedSection = this.dataConfig.getConfigurationSection("blocked");
        if (blockedSection == null) {
            return;
        }
        for (String key : blockedSection.getKeys(false)) {
            try {
                Set blockedSet = this.dataConfig.getStringList("blocked." + key).stream().map(UUID::fromString).collect(Collectors.toSet());
                this.blockedPlayers.put(UUID.fromString(key), ConcurrentHashMap.newKeySet(blockedSet.size()));
                this.blockedPlayers.get(UUID.fromString(key)).addAll(blockedSet);
            }
            catch (Exception exception) {}
        }
    }

    private void loadMail() {
        ConfigurationSection mailSection = this.dataConfig.getConfigurationSection("mail");
        if (mailSection == null) {
            return;
        }
        for (String key : mailSection.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(key);
                List mailList = this.dataConfig.getList("mail." + key);
                ArrayList<Mail> loadedMail = new ArrayList<Mail>();
                for (Object obj : mailList) {
                    if (!(obj instanceof Map)) continue;
                    Map map = (Map)obj;
                    loadedMail.add(new Mail(UUID.fromString((String)map.get("sender")), (Long)map.get("timestamp"), (String)map.get("message")));
                }
                this.mailboxes.put(playerUUID, Collections.synchronizedList(loadedMail));
            }
            catch (Exception exception) {}
        }
    }

    private void loadNicknames() {
        ConfigurationSection nickSection = this.dataConfig.getConfigurationSection("nicknames");
        if (nickSection == null) {
            return;
        }
        for (String key : nickSection.getKeys(false)) {
            try {
                this.nicknames.put(UUID.fromString(key), this.dataConfig.getString("nicknames." + key));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData() {
        try {
            this.dataConfig.set("mutes", null);
            for (UUID uuid : this.mutes.keySet()) {
                this.dataConfig.set("mutes." + uuid.toString(), (Object)this.mutes.get(uuid));
            }
            this.dataConfig.set("blocked", null);
            for (UUID uuid : this.blockedPlayers.keySet()) {
                List blockedList = this.blockedPlayers.get(uuid).stream().map(UUID::toString).collect(Collectors.toList());
                this.dataConfig.set("blocked." + uuid.toString(), blockedList);
            }
            this.dataConfig.set("mail", null);
            for (UUID uuid : this.mailboxes.keySet()) {
                List<Mail> mailList;
                ArrayList serializedMail = new ArrayList();
                List<Mail> list = mailList = this.mailboxes.get(uuid);
                synchronized (list) {
                    for (Mail mail : mailList) {
                        LinkedHashMap<String, Object> mailMap = new LinkedHashMap<String, Object>();
                        mailMap.put("sender", mail.sender().toString());
                        mailMap.put("timestamp", mail.timestamp());
                        mailMap.put("message", mail.message());
                        serializedMail.add(mailMap);
                    }
                }
                this.dataConfig.set("mail." + uuid.toString(), serializedMail);
            }
            this.dataConfig.set("nicknames", null);
            for (UUID uuid : this.nicknames.keySet()) {
                this.dataConfig.set("nicknames." + uuid.toString(), (Object)this.nicknames.get(uuid));
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public String getChatFormat() {
        return this.chatFormat;
    }

    public boolean isChatRangesEnabled() {
        return this.chatRangesEnabled;
    }

    public String getGlobalPrefix() {
        return this.globalPrefix;
    }

    public int getRegionalRadius() {
        return this.regionalRadius;
    }

    public ChatMode getPlayerChatMode(UUID uuid) {
        return this.playerChatModes.getOrDefault(uuid, this.defaultMode);
    }

    public void setPlayerChatMode(UUID uuid, ChatMode mode) {
        this.playerChatModes.put(uuid, mode);
    }

    public boolean isMuted(UUID uuid) {
        if (!this.mutes.containsKey(uuid)) {
            return false;
        }
        long expiration = this.mutes.get(uuid);
        if (expiration == -1L) {
            return true;
        }
        if (System.currentTimeMillis() < expiration) {
            return true;
        }
        this.mutes.remove(uuid);
        this.saveDataAsync();
        return false;
    }

    public void mutePlayer(UUID uuid, long durationMillis) {
        this.mutes.put(uuid, durationMillis == -1L ? -1L : System.currentTimeMillis() + durationMillis);
        this.saveDataAsync();
    }

    public void unmutePlayer(UUID uuid) {
        this.mutes.remove(uuid);
        this.saveDataAsync();
    }

    public UUID getReplyTarget(UUID uuid) {
        return this.replyTargets.get(uuid);
    }

    public void setReplyTarget(UUID player, UUID target) {
        this.replyTargets.put(player, target);
    }

    public boolean isBlocked(UUID target, UUID blocker) {
        Set<UUID> blockers = this.blockedPlayers.get(target);
        return blockers != null && blockers.contains(blocker);
    }

    public void blockPlayer(UUID target, UUID blocker) {
        this.blockedPlayers.computeIfAbsent(target, k -> ConcurrentHashMap.newKeySet()).add(blocker);
        this.saveDataAsync();
    }

    public void unblockPlayer(UUID target, UUID blocker) {
        Set<UUID> blockers = this.blockedPlayers.get(target);
        if (blockers != null) {
            blockers.remove(blocker);
        }
        this.saveDataAsync();
    }

    public void sendMail(UUID sender, UUID target, String message) {
        List mailList = this.mailboxes.computeIfAbsent(target, k -> Collections.synchronizedList(new ArrayList()));
        mailList.add(new Mail(sender, message));
        this.saveDataAsync();
    }

    public List<Mail> getMail(UUID player) {
        return this.mailboxes.get(player);
    }

    public void clearMail(UUID player) {
        this.mailboxes.remove(player);
        this.saveDataAsync();
    }

    public void setNickname(UUID uuid, String nickname) {
        this.nicknames.put(uuid, nickname);
        this.saveDataAsync();
    }

    public String getNickname(UUID uuid) {
        return this.nicknames.get(uuid);
    }

    public void removeNickname(UUID uuid) {
        this.nicknames.remove(uuid);
        this.saveDataAsync();
    }

    public Map<UUID, String> getAllNicknames() {
        return this.nicknames;
    }
}

