/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.listeners;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Kit;
import dev.ajaretro.foliaCore.gui.KitGUI;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitGUIListener
implements Listener {
    private final FoliaCore plugin;

    public KitGUIListener(FoliaCore plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(KitGUI.GUI_TITLE)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "kit_key");
        if (!meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            return;
        }
        String kitName = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        Kit kit = this.plugin.getKitManager().getKit(kitName);
        if (kit == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Error: Kit data not found.");
            return;
        }
        player.closeInventory();
        this.plugin.getKitManager().giveKit(player, kit);
    }
}

