/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.gui;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Kit;
import dev.ajaretro.foliaCore.managers.KitManager;
import dev.ajaretro.foliaCore.utils.TimeUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitGUI {
    private final FoliaCore plugin;
    private final KitManager kitManager;
    private final Player player;
    private Inventory gui;
    public static final String GUI_TITLE = String.valueOf(ChatColor.DARK_BLUE) + "Select a Kit";

    public KitGUI(FoliaCore plugin, Player player) {
        this.plugin = plugin;
        this.kitManager = plugin.getKitManager();
        this.player = player;
    }

    public void openGUI() {
        Collection<Kit> kits = this.kitManager.getAllKits();
        int size = (int)Math.ceil((double)kits.size() / 9.0) * 9;
        this.gui = Bukkit.createInventory(null, (int)Math.max(9, size), (String)GUI_TITLE);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "kit_key");
        for (Kit kit : kits) {
            ItemStack item = new ItemStack(kit.displayMaterial());
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + kit.name());
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)kit.name());
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (this.player.hasPermission(kit.permission())) {
                if (this.kitManager.isOnCooldown(this.player.getUniqueId(), kit)) {
                    long remaining = this.kitManager.getRemainingCooldown(this.player.getUniqueId(), kit);
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "On Cooldown!")));
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Time left: " + TimeUtil.formatDuration(remaining))));
                } else {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Click to redeem!")));
                }
            } else {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_RED) + "Locked")));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Requires permission:")));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + kit.permission())));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.gui.addItem(new ItemStack[]{item});
        }
        this.player.openInventory(this.gui);
    }
}

