/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.economy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class FoliaEconomy
implements Economy {
    private final ConcurrentHashMap<String, Double> balances = new ConcurrentHashMap();

    public Map<String, Double> getBalances() {
        return this.balances;
    }

    public void setBalances(Map<String, Double> loadedBalances) {
        this.balances.clear();
        this.balances.putAll(loadedBalances);
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "FoliaCoreEco";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return String.format("$%.2f", amount);
    }

    public String currencyNamePlural() {
        return "Dollars";
    }

    public String currencyNameSingular() {
        return "Dollar";
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.balances.containsKey(player.getUniqueId().toString());
    }

    public double getBalance(OfflinePlayer player) {
        return this.balances.getOrDefault(player.getUniqueId().toString(), 0.0);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        String uuid = player.getUniqueId().toString();
        ConcurrentHashMap<String, Double> concurrentHashMap = this.balances;
        synchronized (concurrentHashMap) {
            double current = this.balances.getOrDefault(uuid, 0.0);
            if (current < amount) {
                return new EconomyResponse(0.0, current, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
            }
            double newBalance = current - amount;
            this.balances.put(uuid, newBalance);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        String uuid = player.getUniqueId().toString();
        ConcurrentHashMap<String, Double> concurrentHashMap = this.balances;
        synchronized (concurrentHashMap) {
            double current = this.balances.getOrDefault(uuid, 0.0);
            double newBalance = current + amount;
            this.balances.put(uuid, newBalance);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        this.balances.putIfAbsent(player.getUniqueId().toString(), 0.0);
        return true;
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public boolean hasAccount(String playerName) {
        return false;
    }

    public double getBalance(String playerName) {
        return 0.0;
    }

    public boolean has(String playerName, double amount) {
        return false;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Use UUIDs");
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Use UUIDs");
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No Banks");
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }
}

