/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.data;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public record Warp(String name, String worldName, double x, double y, double z, float yaw, float pitch) {
    public Warp(String name, Location location) {
        this(name, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public Location toLocation() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("world", this.worldName);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("z", this.z);
        map.put("yaw", Float.valueOf(this.yaw));
        map.put("pitch", Float.valueOf(this.pitch));
        return map;
    }

    public static Warp deserialize(String name, Map<String, Object> map) {
        return new Warp(name, (String)map.get("world"), (Double)map.get("x"), (Double)map.get("y"), (Double)map.get("z"), ((Number)map.get("yaw")).floatValue(), ((Number)map.get("pitch")).floatValue());
    }
}

