/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.data;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public record Marker(String name, String worldName, double x, double y, double z) {
    public Marker(String name, Location location) {
        this(name, location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public Location toLocation() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, this.x, this.y, this.z);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("world", this.worldName);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("z", this.z);
        return map;
    }

    public static Marker deserialize(String name, Map<String, Object> map) {
        return new Marker(name, (String)map.get("world"), (Double)map.get("x"), (Double)map.get("y"), (Double)map.get("z"));
    }
}

