/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Warp;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public WarpCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /warp <name>");
            return true;
        }
        String warpName = args[0];
        Warp warp = this.plugin.getWarpManager().getWarp(warpName);
        if (warp == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Warp '" + String.valueOf(ChatColor.GOLD) + warpName + String.valueOf(ChatColor.RED) + "' not found.");
            return true;
        }
        String perm = "foliacore.warp." + warp.name().toLowerCase();
        if (!player.hasPermission("foliacore.warp.all") && !player.hasPermission(perm)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this warp.");
            return true;
        }
        Location location = warp.toLocation();
        if (location == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "The world for this warp is not loaded! Please contact an admin.");
            return true;
        }
        String successMsg = "Teleported to warp '" + String.valueOf(ChatColor.GOLD) + warp.name() + String.valueOf(ChatColor.GREEN) + "'.";
        this.plugin.getTeleportManager().startTeleport(player, location, successMsg);
        return true;
    }
}

