/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpDenyCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeleportManager tm;

    public TpDenyCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeleportManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.tpdeny")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        TeleportManager.TeleportRequest request = this.tm.getTpaRequest(player.getUniqueId());
        if (request == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You have no pending teleport requests.");
            return true;
        }
        this.tm.removeTpaRequest(player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Teleport request denied.");
        Player requester = Bukkit.getPlayer((UUID)request.requester());
        if (requester != null && requester.isOnline()) {
            requester.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendError((CommandSender)requester, player.getName() + " denied your teleport request."), null);
        }
        return true;
    }
}

