/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RealNameCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public RealNameCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("foliacore.realname")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError(sender, "Usage: /realname <nickname>");
            return true;
        }
        String targetNick = args[0].toLowerCase();
        Map<UUID, String> nicks = this.plugin.getChatManager().getAllNicknames();
        for (Map.Entry<UUID, String> entry : nicks.entrySet()) {
            String cleanNick = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)entry.getValue())).toLowerCase();
            if (!cleanNick.contains(targetNick)) continue;
            Player target = Bukkit.getPlayer((UUID)entry.getKey());
            String realName = target != null ? target.getName() : Bukkit.getOfflinePlayer((UUID)entry.getKey()).getName();
            this.plugin.getMessenger().sendMessage(sender, "Nickname: " + String.valueOf(ChatColor.RESET) + ChatColor.translateAlternateColorCodes((char)'&', (String)entry.getValue()));
            this.plugin.getMessenger().sendMessage(sender, "Real Name: " + String.valueOf(ChatColor.GOLD) + realName);
            return true;
        }
        this.plugin.getMessenger().sendError(sender, "No player found with that nickname.");
        return true;
    }
}

