/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.EconomyManager;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PayCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final EconomyManager eco;

    public PayCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.eco = plugin.getEconomyManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!this.eco.hasEconomy()) {
            this.plugin.getMessenger().sendError(sender, "Economy features are disabled.");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.pay")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /pay <player> <amount>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (!target.hasPlayedBefore()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Player not found.");
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You cannot pay yourself.");
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Invalid amount.");
            return true;
        }
        if (amount <= 0.0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Amount must be greater than zero.");
            return true;
        }
        if (!this.eco.has((OfflinePlayer)player, amount)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have enough money.");
            return true;
        }
        EconomyResponse r = this.eco.withdraw((OfflinePlayer)player, amount);
        if (r.transactionSuccess()) {
            this.eco.deposit(target, amount);
            String formattedAmount = this.eco.format(amount);
            this.plugin.getMessenger().sendSuccess((CommandSender)player, "You sent " + String.valueOf(ChatColor.GOLD) + formattedAmount + String.valueOf(ChatColor.GREEN) + " to " + target.getName() + ".");
            Player onlineTarget = target.getPlayer();
            if (onlineTarget != null) {
                onlineTarget.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendMessage((CommandSender)onlineTarget, String.valueOf(ChatColor.GOLD) + player.getName() + String.valueOf(ChatColor.WHITE) + " sent you " + String.valueOf(ChatColor.GOLD) + formattedAmount), null);
            }
        } else {
            this.plugin.getMessenger().sendError((CommandSender)player, "An error occurred: " + r.errorMessage);
        }
        return true;
    }
}

