/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NickCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public NickCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "Only players can set a nickname.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.nick")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to change your nickname.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /nick <name|off>");
            return true;
        }
        String input = args[0];
        if (input.equalsIgnoreCase("off") || input.equalsIgnoreCase("reset")) {
            this.plugin.getChatManager().removeNickname(player.getUniqueId());
            player.displayName((Component)Component.text((String)player.getName()));
            if (player.hasPermission("foliacore.nick.color")) {
                player.playerListName((Component)Component.text((String)player.getName()));
            }
            this.plugin.getMessenger().sendSuccess((CommandSender)player, "Nickname reset.");
            return true;
        }
        if (!player.hasPermission("foliacore.nick.color")) {
            input = input.replaceAll("&[0-9a-fk-or]", "");
        }
        String formattedNick = LegacyComponentSerializer.legacyAmpersand().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(input));
        this.plugin.getChatManager().setNickname(player.getUniqueId(), formattedNick);
        TextComponent nickComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(formattedNick);
        player.displayName((Component)nickComponent);
        player.playerListName((Component)nickComponent);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Your nickname is now: " + formattedNick);
        return true;
    }
}

