/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.utils.TimeUtil;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MuteCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public MuteCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Object durationFormatted;
        long duration;
        if (!sender.hasPermission("foliacore.mute")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError(sender, "Usage: /mute <player> <time|permanent>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore()) {
            this.plugin.getMessenger().sendError(sender, "Player not found.");
            return true;
        }
        String timeString = args[1];
        if (timeString.equalsIgnoreCase("perm") || timeString.equalsIgnoreCase("permanent")) {
            duration = -1L;
            durationFormatted = "permanently";
        } else {
            duration = TimeUtil.parseTime(timeString);
            if (duration <= 0L) {
                this.plugin.getMessenger().sendError(sender, "Invalid time format. Use: 10s, 5m, 1h, 3d");
                return true;
            }
            durationFormatted = "for " + TimeUtil.formatDuration(duration);
        }
        this.plugin.getChatManager().mutePlayer(target.getUniqueId(), duration);
        this.plugin.getMessenger().sendSuccess(sender, target.getName() + " has been " + (String)durationFormatted + " muted.");
        Player onlineTarget = target.getPlayer();
        if (onlineTarget != null) {
            onlineTarget.getScheduler().run((Plugin)this.plugin, arg_0 -> this.lambda$onCommand$0(onlineTarget, (String)durationFormatted, arg_0), null);
        }
        return true;
    }

    private /* synthetic */ void lambda$onCommand$0(Player onlineTarget, String durationFormatted, ScheduledTask task) {
        this.plugin.getMessenger().sendError((CommandSender)onlineTarget, "You have been " + durationFormatted + " muted.");
    }
}

