/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MsgCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public MsgCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        if (!sender.hasPermission("foliacore.msg")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError(sender, "Usage: /msg <player> <message...>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            this.plugin.getMessenger().sendError(sender, "Player not found or is not online.");
            return true;
        }
        Player player = (Player)sender;
        if (player.equals((Object)target)) {
            this.plugin.getMessenger().sendError(sender, "You cannot message yourself.");
            return true;
        }
        if (this.plugin.getChatManager().isBlocked(player.getUniqueId(), target.getUniqueId())) {
            this.plugin.getMessenger().sendError(sender, "You cannot message this player as they have you blocked.");
            return true;
        }
        if (this.plugin.getChatManager().isBlocked(target.getUniqueId(), player.getUniqueId())) {
            this.plugin.getMessenger().sendError(sender, "You have this player blocked. Use /unblock to message them.");
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            messageBuilder.append(args[i]).append(" ");
        }
        String message = messageBuilder.toString().trim();
        String senderFormat = String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + "You -> " + target.getName() + ": " + message;
        String targetFormat = String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + player.getName() + " -> You: " + message;
        player.sendMessage(senderFormat);
        target.getScheduler().run((Plugin)this.plugin, scheduledTask -> target.sendMessage(targetFormat), null);
        this.plugin.getChatManager().setReplyTarget(player.getUniqueId(), target.getUniqueId());
        this.plugin.getChatManager().setReplyTarget(target.getUniqueId(), player.getUniqueId());
        return true;
    }
}

