/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Marker;
import dev.ajaretro.foliaCore.managers.MarkerManager;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MarkerCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final MarkerManager markerManager;
    private static final Pattern MARKER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,20}$");

    public MarkerCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.markerManager = plugin.getMarkerManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                this.handleSet(player, args);
                break;
            }
            case "del": 
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void sendHelp(Player player) {
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "--- FoliaCore Marker Help ---");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/marker set <name>" + String.valueOf(ChatColor.WHITE) + " - Save your current location.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/marker del <name>" + String.valueOf(ChatColor.WHITE) + " - Delete a saved marker.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/marker list" + String.valueOf(ChatColor.WHITE) + " - List all your markers.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/gps <name>" + String.valueOf(ChatColor.WHITE) + " - Start navigation to a marker.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/gps off" + String.valueOf(ChatColor.WHITE) + " - Stop navigation.");
    }

    private void handleSet(Player player, String[] args) {
        if (!player.hasPermission("foliacore.marker.set")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to set markers.");
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /marker set <name>");
            return;
        }
        String name = args[1];
        if (!MARKER_NAME_PATTERN.matcher(name).matches()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Marker name must be 3-20 characters (letters, numbers, underscore).");
            return;
        }
        this.markerManager.setMarker(player.getUniqueId(), name, player.getLocation());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Marker '" + String.valueOf(ChatColor.GOLD) + name + String.valueOf(ChatColor.GREEN) + "' has been saved!");
    }

    private void handleDelete(Player player, String[] args) {
        if (!player.hasPermission("foliacore.marker.delete")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to delete markers.");
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /marker del <name>");
            return;
        }
        String name = args[1];
        if (this.markerManager.getMarker(player.getUniqueId(), name) == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "A marker with that name was not found.");
            return;
        }
        this.markerManager.deleteMarker(player.getUniqueId(), name);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Marker '" + String.valueOf(ChatColor.GOLD) + name + String.valueOf(ChatColor.GREEN) + "' has been deleted.");
    }

    private void handleList(Player player) {
        if (!player.hasPermission("foliacore.marker.list")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to list markers.");
            return;
        }
        Map<String, Marker> markers = this.markerManager.getMarkers(player.getUniqueId());
        if (markers.isEmpty()) {
            this.plugin.getMessenger().sendMessage((CommandSender)player, "You have no markers set.");
            return;
        }
        String list = markers.values().stream().map(Marker::name).sorted().collect(Collectors.joining(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.WHITE)));
        this.plugin.getMessenger().sendMessage((CommandSender)player, "Your Markers: " + String.valueOf(ChatColor.WHITE) + list);
    }
}

