/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Home;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomesCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeleportManager tm;

    public HomesCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeleportManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.homes.list")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to list your homes.");
            return true;
        }
        Map<String, Home> homes = this.tm.getHomes(player.getUniqueId());
        int maxHomes = this.tm.getMaxHomes(player);
        if (homes.isEmpty()) {
            this.plugin.getMessenger().sendMessage((CommandSender)player, "You have no homes set.");
            return true;
        }
        String homesList = homes.keySet().stream().sorted().collect(Collectors.joining(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.WHITE)));
        this.plugin.getMessenger().sendMessage((CommandSender)player, "Your Homes (" + homes.size() + "/" + String.valueOf(maxHomes == Integer.MAX_VALUE ? "Unlimited" : Integer.valueOf(maxHomes)) + "): " + String.valueOf(ChatColor.WHITE) + homesList);
        return true;
    }
}

