/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Marker;
import dev.ajaretro.foliaCore.managers.MarkerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GpsCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final MarkerManager markerManager;

    public GpsCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.markerManager = plugin.getMarkerManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.gps")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use the GPS.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /gps <marker_name> | /gps off");
            return true;
        }
        String arg = args[0].toLowerCase();
        if (arg.equals("off") || arg.equals("stop")) {
            if (this.markerManager.isGpsActive(player.getUniqueId())) {
                this.markerManager.stopGps(player);
            } else {
                this.plugin.getMessenger().sendError((CommandSender)player, "GPS is not active.");
            }
            return true;
        }
        Marker marker = this.markerManager.getMarker(player.getUniqueId(), arg);
        if (marker == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Marker '" + String.valueOf(ChatColor.GOLD) + args[0] + String.valueOf(ChatColor.RED) + "' not found.");
            return true;
        }
        this.markerManager.startGps(player, marker);
        return true;
    }
}

