/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class EcoCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final EconomyManager eco;

    public EcoCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.eco = plugin.getEconomyManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!this.eco.hasEconomy()) {
            this.plugin.getMessenger().sendError(sender, "Economy features are disabled.");
            return true;
        }
        if (!sender.hasPermission("foliacore.eco")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 3) {
            this.sendHelp(sender);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore()) {
            this.plugin.getMessenger().sendError(sender, "Player not found.");
            return true;
        }
        try {
            amount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessenger().sendError(sender, "Invalid amount.");
            return true;
        }
        if (amount < 0.0) {
            this.plugin.getMessenger().sendError(sender, "Amount cannot be negative.");
            return true;
        }
        String formattedAmount = this.eco.format(amount);
        switch (subCommand) {
            case "give": {
                this.eco.deposit(target, amount);
                this.plugin.getMessenger().sendSuccess(sender, "Gave " + String.valueOf(ChatColor.GOLD) + formattedAmount + String.valueOf(ChatColor.GREEN) + " to " + target.getName());
                break;
            }
            case "take": {
                this.eco.withdraw(target, amount);
                this.plugin.getMessenger().sendSuccess(sender, "Took " + String.valueOf(ChatColor.GOLD) + formattedAmount + String.valueOf(ChatColor.GREEN) + " from " + target.getName());
                break;
            }
            case "set": {
                double balance = this.eco.getBalance(target);
                this.eco.withdraw(target, balance);
                this.eco.deposit(target, amount);
                this.plugin.getMessenger().sendSuccess(sender, "Set " + target.getName() + "'s balance to " + String.valueOf(ChatColor.GOLD) + formattedAmount);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        this.plugin.getMessenger().sendMessage(sender, String.valueOf(ChatColor.YELLOW) + "--- FoliaCore Economy Admin ---");
        this.plugin.getMessenger().sendMessage(sender, String.valueOf(ChatColor.GOLD) + "/eco give <player> <amount>");
        this.plugin.getMessenger().sendMessage(sender, String.valueOf(ChatColor.GOLD) + "/eco take <player> <amount>");
        this.plugin.getMessenger().sendMessage(sender, String.valueOf(ChatColor.GOLD) + "/eco set <player> <amount>");
    }
}

