/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.KitManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DeleteKitCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final KitManager kitManager;

    public DeleteKitCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.kitManager = plugin.getKitManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("foliacore.kit.admin")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError(sender, "Usage: /delkit <name>");
            return true;
        }
        String kitName = args[0];
        if (!this.kitManager.isKit(kitName)) {
            this.plugin.getMessenger().sendError(sender, "A kit with the name '" + String.valueOf(ChatColor.GOLD) + kitName + String.valueOf(ChatColor.RED) + "' does not exist.");
            return true;
        }
        this.kitManager.deleteKit(kitName);
        this.plugin.getMessenger().sendSuccess(sender, "Kit '" + String.valueOf(ChatColor.GOLD) + kitName + String.valueOf(ChatColor.GREEN) + "' has been deleted.");
        return true;
    }
}

