/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DelWarpCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public DelWarpCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("foliacore.delwarp")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError(sender, "Usage: /delwarp <name>");
            return true;
        }
        String warpName = args[0];
        if (!this.plugin.getWarpManager().isWarp(warpName)) {
            this.plugin.getMessenger().sendError(sender, "Warp '" + String.valueOf(ChatColor.GOLD) + warpName + String.valueOf(ChatColor.RED) + "' not found.");
            return true;
        }
        this.plugin.getWarpManager().deleteWarp(warpName);
        this.plugin.getMessenger().sendSuccess(sender, "Warp '" + String.valueOf(ChatColor.GOLD) + warpName + String.valueOf(ChatColor.GREEN) + "' has been deleted.");
        return true;
    }
}

