/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.KitManager;
import dev.ajaretro.foliaCore.utils.TimeUtil;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CreateKitCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final KitManager kitManager;
    private static final Pattern KIT_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,20}$");

    public CreateKitCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.kitManager = plugin.getKitManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.kit.admin")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /createkit <name> <cooldown>");
            this.plugin.getMessenger().sendError((CommandSender)player, "Example: /createkit starter 1d");
            return true;
        }
        String kitName = args[0];
        String timeString = args[1];
        if (!KIT_NAME_PATTERN.matcher(kitName).matches()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Kit name must be 3-20 characters and only contain letters, numbers, and underscores.");
            return true;
        }
        if (this.kitManager.isKit(kitName)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "A kit with that name already exists. Use /delkit first.");
            return true;
        }
        long cooldownSeconds = TimeUtil.parseTime(timeString) / 1000L;
        if (cooldownSeconds <= 0L) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Invalid time format. Use: 10s, 5m, 1h, 3d");
            return true;
        }
        ItemStack displayItem = player.getInventory().getItemInMainHand();
        if (displayItem.getType() == Material.AIR) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You must be holding an item to use as the kit's display icon.");
            return true;
        }
        String permission = "foliacore.kit." + kitName.toLowerCase();
        ItemStack[] items = player.getInventory().getContents();
        this.kitManager.createKit(kitName, cooldownSeconds, permission, displayItem.getType(), items);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Kit '" + String.valueOf(ChatColor.GOLD) + kitName + String.valueOf(ChatColor.GREEN) + "' created with a " + TimeUtil.formatDuration(cooldownSeconds * 1000L) + " cooldown.");
        return true;
    }
}

