/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.ChatMode;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public ChatCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ChatMode mode;
        String modeString;
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ChatMode currentMode = this.plugin.getChatManager().getPlayerChatMode(player.getUniqueId());
            this.plugin.getMessenger().sendMessage((CommandSender)player, "Your current chat mode is: " + String.valueOf(ChatColor.GOLD) + currentMode.name());
            this.plugin.getMessenger().sendMessage((CommandSender)player, "Usage: /chat <global|world|regional>");
            return true;
        }
        switch (modeString = args[0].toLowerCase()) {
            case "g": 
            case "global": {
                if (!player.hasPermission("foliacore.chat.global")) {
                    this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use global chat.");
                    return true;
                }
                mode = ChatMode.GLOBAL;
                break;
            }
            case "w": 
            case "world": {
                if (!player.hasPermission("foliacore.chat.world")) {
                    this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use world chat.");
                    return true;
                }
                mode = ChatMode.WORLD;
                break;
            }
            case "r": 
            case "regional": 
            case "local": {
                if (!player.hasPermission("foliacore.chat.regional")) {
                    this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use regional chat.");
                    return true;
                }
                mode = ChatMode.REGIONAL;
                break;
            }
            default: {
                this.plugin.getMessenger().sendError((CommandSender)player, "Unknown chat mode. Use: global, world, or regional.");
                return true;
            }
        }
        this.plugin.getChatManager().setPlayerChatMode(player.getUniqueId(), mode);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Your chat mode has been set to " + String.valueOf(ChatColor.GOLD) + mode.name());
        return true;
    }
}

