/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final EconomyManager eco;

    public BalanceCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.eco = plugin.getEconomyManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.eco.hasEconomy()) {
            this.plugin.getMessenger().sendError(sender, "Economy features are disabled. Please install Vault and an economy plugin.");
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.plugin.getMessenger().sendError(sender, "Only players can check their own balance.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("foliacore.balance.self")) {
                this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to check your balance.");
                return true;
            }
            double balance = this.eco.getBalance((OfflinePlayer)player);
            this.plugin.getMessenger().sendMessage((CommandSender)player, "Your balance: " + String.valueOf(ChatColor.GOLD) + this.eco.format(balance));
        } else {
            if (!sender.hasPermission("foliacore.balance.other")) {
                this.plugin.getMessenger().sendError(sender, "You do not have permission to check other players' balances.");
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            if (!target.hasPlayedBefore()) {
                this.plugin.getMessenger().sendError(sender, "Player not found.");
                return true;
            }
            double balance = this.eco.getBalance(target);
            this.plugin.getMessenger().sendMessage(sender, target.getName() + "'s balance: " + String.valueOf(ChatColor.GOLD) + this.eco.format(balance));
        }
        return true;
    }
}

