/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore;

import dev.ajaretro.foliaCore.commands.BalanceCommand;
import dev.ajaretro.foliaCore.commands.BlockCommand;
import dev.ajaretro.foliaCore.commands.ChatCommand;
import dev.ajaretro.foliaCore.commands.CreateKitCommand;
import dev.ajaretro.foliaCore.commands.DelHomeCommand;
import dev.ajaretro.foliaCore.commands.DelWarpCommand;
import dev.ajaretro.foliaCore.commands.DeleteKitCommand;
import dev.ajaretro.foliaCore.commands.EcoCommand;
import dev.ajaretro.foliaCore.commands.GpsCommand;
import dev.ajaretro.foliaCore.commands.HomeCommand;
import dev.ajaretro.foliaCore.commands.HomesCommand;
import dev.ajaretro.foliaCore.commands.KitCommand;
import dev.ajaretro.foliaCore.commands.MailCommand;
import dev.ajaretro.foliaCore.commands.MarkerCommand;
import dev.ajaretro.foliaCore.commands.MsgCommand;
import dev.ajaretro.foliaCore.commands.MuteCommand;
import dev.ajaretro.foliaCore.commands.NickCommand;
import dev.ajaretro.foliaCore.commands.PayCommand;
import dev.ajaretro.foliaCore.commands.RealNameCommand;
import dev.ajaretro.foliaCore.commands.ReplyCommand;
import dev.ajaretro.foliaCore.commands.SetHomeCommand;
import dev.ajaretro.foliaCore.commands.SetSpawnCommand;
import dev.ajaretro.foliaCore.commands.SetWarpCommand;
import dev.ajaretro.foliaCore.commands.SpawnCommand;
import dev.ajaretro.foliaCore.commands.TeamCommand;
import dev.ajaretro.foliaCore.commands.TpAcceptCommand;
import dev.ajaretro.foliaCore.commands.TpDenyCommand;
import dev.ajaretro.foliaCore.commands.TpaCommand;
import dev.ajaretro.foliaCore.commands.TpaHereCommand;
import dev.ajaretro.foliaCore.commands.UnblockCommand;
import dev.ajaretro.foliaCore.commands.UnmuteCommand;
import dev.ajaretro.foliaCore.commands.WarpCommand;
import dev.ajaretro.foliaCore.commands.WarpsCommand;
import dev.ajaretro.foliaCore.economy.FoliaEconomy;
import dev.ajaretro.foliaCore.listeners.ChatListener;
import dev.ajaretro.foliaCore.listeners.ConnectionListener;
import dev.ajaretro.foliaCore.listeners.KitGUIListener;
import dev.ajaretro.foliaCore.listeners.MailListener;
import dev.ajaretro.foliaCore.listeners.PlayerGpsListener;
import dev.ajaretro.foliaCore.listeners.PlayerMoveListener;
import dev.ajaretro.foliaCore.managers.ChatManager;
import dev.ajaretro.foliaCore.managers.EconomyManager;
import dev.ajaretro.foliaCore.managers.KitManager;
import dev.ajaretro.foliaCore.managers.MarkerManager;
import dev.ajaretro.foliaCore.managers.TeamManager;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import dev.ajaretro.foliaCore.managers.WarpManager;
import dev.ajaretro.foliaCore.metrics.bukkit.Metrics;
import dev.ajaretro.foliaCore.metrics.charts.SimplePie;
import dev.ajaretro.foliaCore.utils.Messenger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class FoliaCore
extends JavaPlugin {
    private static FoliaCore instance;
    private ChatManager chatManager;
    private TeleportManager teleportManager;
    private TeamManager teamManager;
    private KitManager kitManager;
    private WarpManager warpManager;
    private MarkerManager markerManager;
    private EconomyManager economyManager;
    private Messenger messenger;

    public void onEnable() {
        instance = this;
        this.messenger = new Messenger("&l[ &4AJA_RETRO/&3FoliaCore&f ]");
        int pluginId = 28430;
        try {
            Metrics metrics = new Metrics((Plugin)this, pluginId);
            metrics.addCustomChart(new SimplePie("chart_id", () -> "My Value"));
            this.getLogger().info("bStats metrics enabled.");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to enable bStats metrics.");
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("This plugin requires Folia! Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().register(Economy.class, (Object)new FoliaEconomy(), (Plugin)this, ServicePriority.Highest);
            Bukkit.getConsoleSender().sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize("&l&4[FoliaCore] &aVault found! Economy Provider registered."));
        } else {
            this.getLogger().warning("Vault NOT found! Economy features will be disabled.");
        }
        this.chatManager = new ChatManager(this);
        this.teleportManager = new TeleportManager(this);
        this.teamManager = new TeamManager(this);
        this.kitManager = new KitManager(this);
        this.warpManager = new WarpManager(this);
        this.markerManager = new MarkerManager(this);
        this.economyManager = new EconomyManager(this);
        this.loadSubsystems();
        this.registerListeners();
        this.registerCommands();
        Bukkit.getConsoleSender().sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize("&l&4[FoliaCore] &aPlugin initialized successfully! &7(Backend: REGIONIZED)"));
    }

    public void onDisable() {
        if (this.chatManager != null) {
            this.chatManager.saveData();
        }
        if (this.teleportManager != null) {
            this.teleportManager.saveData();
        }
        if (this.teamManager != null) {
            this.teamManager.saveData();
        }
        if (this.kitManager != null) {
            this.kitManager.saveData();
        }
        if (this.warpManager != null) {
            this.warpManager.saveData();
        }
        if (this.markerManager != null) {
            this.markerManager.saveData();
        }
        if (this.economyManager != null) {
            this.economyManager.saveData();
        }
        this.getLogger().info("FoliaCore shutdown sequence completed.");
    }

    private void loadSubsystems() {
        if (this.chatManager != null) {
            this.chatManager.load();
        }
        if (this.teleportManager != null) {
            this.teleportManager.load();
        }
        if (this.teamManager != null) {
            this.teamManager.load();
        }
        if (this.kitManager != null) {
            this.kitManager.load();
        }
        if (this.warpManager != null) {
            this.warpManager.load();
        }
        if (this.markerManager != null) {
            this.markerManager.load();
        }
        if (this.economyManager != null) {
            this.economyManager.load();
        }
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new ChatListener(this), (Plugin)this);
        pm.registerEvents((Listener)new MailListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        pm.registerEvents((Listener)new KitGUIListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerGpsListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand(this));
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand(this));
        this.getCommand("msg").setExecutor((CommandExecutor)new MsgCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("block").setExecutor((CommandExecutor)new BlockCommand(this));
        this.getCommand("unblock").setExecutor((CommandExecutor)new UnblockCommand(this));
        this.getCommand("mail").setExecutor((CommandExecutor)new MailCommand(this));
        this.getCommand("chat").setExecutor((CommandExecutor)new ChatCommand(this));
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand(this));
        this.getCommand("home").setExecutor((CommandExecutor)new HomeCommand(this));
        this.getCommand("delhome").setExecutor((CommandExecutor)new DelHomeCommand(this));
        this.getCommand("homes").setExecutor((CommandExecutor)new HomesCommand(this));
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand(this));
        this.getCommand("tpahere").setExecutor((CommandExecutor)new TpaHereCommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpAcceptCommand(this));
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpDenyCommand(this));
        this.getCommand("setspawn").setExecutor((CommandExecutor)new SetSpawnCommand(this));
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this));
        this.getCommand("team").setExecutor((CommandExecutor)new TeamCommand(this));
        this.getCommand("kit").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("createkit").setExecutor((CommandExecutor)new CreateKitCommand(this));
        this.getCommand("delkit").setExecutor((CommandExecutor)new DeleteKitCommand(this));
        this.getCommand("marker").setExecutor((CommandExecutor)new MarkerCommand(this));
        this.getCommand("gps").setExecutor((CommandExecutor)new GpsCommand(this));
        this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarpCommand(this));
        this.getCommand("delwarp").setExecutor((CommandExecutor)new DelWarpCommand(this));
        this.getCommand("warp").setExecutor((CommandExecutor)new WarpCommand(this));
        this.getCommand("warps").setExecutor((CommandExecutor)new WarpsCommand(this));
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this));
        this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this));
        this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand(this));
        this.getCommand("nick").setExecutor((CommandExecutor)new NickCommand(this));
        this.getCommand("realname").setExecutor((CommandExecutor)new RealNameCommand(this));
    }

    public static FoliaCore getInstance() {
        return instance;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public WarpManager getWarpManager() {
        return this.warpManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }
}

