/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.utils;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)([smhd])");

    public static long parseTime(String timeString) {
        long totalMillis = 0L;
        Matcher matcher = TIME_PATTERN.matcher(timeString);
        if (!matcher.find()) {
            return -1L;
        }
        matcher.reset();
        while (matcher.find()) {
            try {
                String unit;
                long value = Long.parseLong(matcher.group(1));
                switch (unit = matcher.group(2)) {
                    case "s": {
                        totalMillis += TimeUnit.SECONDS.toMillis(value);
                        break;
                    }
                    case "m": {
                        totalMillis += TimeUnit.MINUTES.toMillis(value);
                        break;
                    }
                    case "h": {
                        totalMillis += TimeUnit.HOURS.toMillis(value);
                        break;
                    }
                    case "d": {
                        totalMillis += TimeUnit.DAYS.toMillis(value);
                    }
                }
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return totalMillis;
    }

    public static String formatDuration(long millis) {
        String formatted;
        if (millis < 0L) {
            return "Permanent";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s");
        }
        return (formatted = sb.toString().trim()).isEmpty() ? "0s" : formatted;
    }
}

