/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.utils;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Messenger {
    private final String prefix;

    public Messenger(String prefix) {
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)prefix) + " " + String.valueOf(ChatColor.RESET);
    }

    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.WHITE) + message);
    }

    public void sendError(CommandSender sender, String errorMessage) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + errorMessage);
    }

    public void sendSuccess(CommandSender sender, String successMessage) {
        sender.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + successMessage);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String componentToString(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }
}

