/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemUtil {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeItems(ItemStack[] items) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    dataOutput.writeObject((Object)item);
                }
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack[] deserializeItems(String base64String) {
        if (base64String == null || base64String.isEmpty()) {
            return new ItemStack[0];
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64String));){
            ItemStack[] itemStackArray;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                int size = dataInput.readInt();
                ItemStack[] items = new ItemStack[size];
                for (int i = 0; i < size; ++i) {
                    items[i] = (ItemStack)dataInput.readObject();
                }
                itemStackArray = items;
            }
            return itemStackArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemStack[0];
        }
    }
}

