/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Warp;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class WarpManager {
    private final FoliaCore plugin;
    private final ConcurrentHashMap<String, Warp> warps;
    private File dataFile;
    private FileConfiguration dataConfig;

    public WarpManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.warps = new ConcurrentHashMap();
    }

    public void load() {
        this.dataFile = new File(this.plugin.getDataFolder(), "warps.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("warps.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadWarps();
    }

    private void loadWarps() {
        ConfigurationSection warpsSection = this.dataConfig.getConfigurationSection("warps");
        if (warpsSection == null) {
            return;
        }
        for (String warpName : warpsSection.getKeys(false)) {
            try {
                ConfigurationSection warpSection = warpsSection.getConfigurationSection(warpName);
                if (warpSection == null) continue;
                Map warpData = warpSection.getValues(false);
                Warp warp = Warp.deserialize(warpName, warpData);
                this.warps.put(warpName.toLowerCase(), warp);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load warp: " + warpName);
            }
        }
    }

    public void saveData() {
        try {
            this.dataConfig.set("warps", null);
            for (Map.Entry<String, Warp> entry : this.warps.entrySet()) {
                this.dataConfig.set("warps." + entry.getKey(), entry.getValue().serialize());
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save warps to file!");
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public void createWarp(String name, Location location) {
        Warp warp = new Warp(name, location);
        this.warps.put(name.toLowerCase(), warp);
        this.saveDataAsync();
    }

    public void deleteWarp(String name) {
        this.warps.remove(name.toLowerCase());
        this.saveDataAsync();
    }

    public Warp getWarp(String name) {
        return this.warps.get(name.toLowerCase());
    }

    public boolean isWarp(String name) {
        return this.warps.containsKey(name.toLowerCase());
    }

    public Collection<Warp> getAllWarps() {
        return this.warps.values();
    }
}

