/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Home;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class TeleportManager {
    private static TeleportManager instance;
    private final FoliaCore plugin;
    private final ConcurrentHashMap<UUID, Map<String, Home>> playerHomes;
    private final ConcurrentHashMap<UUID, ScheduledTask> pendingTeleports;
    private final ConcurrentHashMap<UUID, TeleportRequest> pendingTpaRequests;
    private Location spawnLocation;
    private File dataFile;
    private FileConfiguration dataConfig;
    private static final long TPA_REQUEST_TIMEOUT_MS = 60000L;
    private static final long TELEPORT_DELAY_TICKS = 60L;

    public TeleportManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.playerHomes = new ConcurrentHashMap();
        this.pendingTeleports = new ConcurrentHashMap();
        this.pendingTpaRequests = new ConcurrentHashMap();
        this.spawnLocation = null;
    }

    public static TeleportManager getInstance() {
        return instance;
    }

    public void load() {
        instance = this;
        this.dataFile = new File(this.plugin.getDataFolder(), "teleport_data.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("teleport_data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadHomes();
        this.loadSpawn();
    }

    private void loadHomes() {
        ConfigurationSection homesSection = this.dataConfig.getConfigurationSection("homes");
        if (homesSection == null) {
            return;
        }
        for (String uuidString : homesSection.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                ConfigurationSection playerHomeSection = homesSection.getConfigurationSection(uuidString);
                if (playerHomeSection == null) continue;
                ConcurrentHashMap<String, Home> homes = new ConcurrentHashMap<String, Home>();
                for (String homeName : playerHomeSection.getKeys(false)) {
                    ConfigurationSection homeSection = playerHomeSection.getConfigurationSection(homeName);
                    if (homeSection == null) continue;
                    Map homeData = homeSection.getValues(false);
                    homes.put(homeName.toLowerCase(), Home.deserialize(homeData));
                }
                this.playerHomes.put(playerUUID, homes);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load homes for invalid UUID: " + uuidString);
            }
        }
    }

    private void loadSpawn() {
        ConfigurationSection spawnSection = this.dataConfig.getConfigurationSection("spawn");
        if (spawnSection != null) {
            try {
                Map spawnData = spawnSection.getValues(false);
                this.spawnLocation = Location.deserialize((Map)spawnData);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load spawn location from teleport_data.yml!");
            }
        }
    }

    public void saveData() {
        try {
            this.dataConfig.set("homes", null);
            for (Map.Entry<UUID, Map<String, Home>> entry : this.playerHomes.entrySet()) {
                String uuidString = entry.getKey().toString();
                for (Map.Entry<String, Home> homeEntry : entry.getValue().entrySet()) {
                    this.dataConfig.set("homes." + uuidString + "." + homeEntry.getKey(), homeEntry.getValue().serialize());
                }
            }
            if (this.spawnLocation != null) {
                this.dataConfig.set("spawn", (Object)this.spawnLocation.serialize());
            } else {
                this.dataConfig.set("spawn", null);
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save teleport data to file!");
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public void setSpawn(Location location) {
        this.spawnLocation = location;
        this.saveDataAsync();
    }

    public Location getSpawn() {
        if (this.spawnLocation == null) {
            return ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
        }
        return this.spawnLocation;
    }

    public void setHome(UUID playerUUID, String homeName, Location location) {
        this.playerHomes.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(homeName.toLowerCase(), new Home(location));
        this.saveDataAsync();
    }

    public Home getHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        if (homes == null) {
            return null;
        }
        return homes.get(homeName.toLowerCase());
    }

    public void deleteHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        if (homes != null) {
            homes.remove(homeName.toLowerCase());
            this.saveDataAsync();
        }
    }

    public int getHomeCount(UUID playerUUID) {
        Map<String, Home> homes = this.playerHomes.get(playerUUID);
        return homes == null ? 0 : homes.size();
    }

    public Map<String, Home> getHomes(UUID playerUUID) {
        return this.playerHomes.getOrDefault(playerUUID, Collections.emptyMap());
    }

    public int getMaxHomes(Player player) {
        if (player.hasPermission("foliacore.homes.unlimited")) {
            return Integer.MAX_VALUE;
        }
        int max = 0;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission();
            if (!perm.startsWith("foliacore.homes.")) continue;
            try {
                String numString = perm.substring(16);
                int num = Integer.parseInt(numString);
                if (num <= max) continue;
                max = num;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (max == 0 && player.hasPermission("foliacore.homes.default")) {
            return 1;
        }
        return max;
    }

    public void startTeleport(Player player, Location location, String successMessage) {
        if (this.isTeleporting(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are already teleporting!");
            return;
        }
        this.plugin.getMessenger().sendMessage((CommandSender)player, "Teleporting... Don't move for 3 seconds...");
        ScheduledTask task = player.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> {
            this.completeTeleport(player.getUniqueId());
            player.teleportAsync(location);
            this.plugin.getMessenger().sendSuccess((CommandSender)player, successMessage);
        }, null, 60L);
        this.pendingTeleports.put(player.getUniqueId(), task);
    }

    public void cancelTeleport(Player player) {
        ScheduledTask existingTask = this.pendingTeleports.remove(player.getUniqueId());
        if (existingTask != null && !existingTask.isCancelled()) {
            existingTask.cancel();
            this.plugin.getMessenger().sendError((CommandSender)player, "Teleport cancelled.");
        }
    }

    public void completeTeleport(UUID uuid) {
        this.pendingTeleports.remove(uuid);
    }

    public boolean isTeleporting(UUID uuid) {
        return this.pendingTeleports.containsKey(uuid);
    }

    public void createTpaRequest(UUID requester, UUID target, TpaType type) {
        TeleportRequest request = new TeleportRequest(requester, target, type, System.currentTimeMillis());
        this.pendingTpaRequests.put(target, request);
    }

    public TeleportRequest getTpaRequest(UUID target) {
        TeleportRequest request = this.pendingTpaRequests.get(target);
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.timestamp() > 60000L) {
            this.pendingTpaRequests.remove(target);
            return null;
        }
        return request;
    }

    public void removeTpaRequest(UUID target) {
        this.pendingTpaRequests.remove(target);
    }

    public record TeleportRequest(UUID requester, UUID target, TpaType type, long timestamp) {
    }

    public static enum TpaType {
        TPA,
        TPAHERE;

    }
}

