/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Team;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class TeamManager {
    private static TeamManager instance;
    private final FoliaCore plugin;
    private final ConcurrentHashMap<String, Team> teamsByName;
    private final ConcurrentHashMap<UUID, Team> teamByPlayer;
    private final ConcurrentHashMap<UUID, TeamInvite> pendingInvites;
    private File dataFile;
    private FileConfiguration dataConfig;
    private static final long INVITE_TIMEOUT_MS = 60000L;

    public TeamManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.teamsByName = new ConcurrentHashMap();
        this.teamByPlayer = new ConcurrentHashMap();
        this.pendingInvites = new ConcurrentHashMap();
    }

    public static TeamManager getInstance() {
        return instance;
    }

    public void load() {
        instance = this;
        this.dataFile = new File(this.plugin.getDataFolder(), "team_data.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("team_data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadTeams();
    }

    private void loadTeams() {
        ConfigurationSection teamsSection = this.dataConfig.getConfigurationSection("teams");
        if (teamsSection == null) {
            return;
        }
        for (String teamName : teamsSection.getKeys(false)) {
            try {
                ConfigurationSection teamSection = teamsSection.getConfigurationSection(teamName);
                if (teamSection == null) continue;
                Map teamData = teamSection.getValues(false);
                Team team = Team.deserialize(teamName, teamData);
                this.teamsByName.put(teamName.toLowerCase(), team);
                for (UUID member : team.getMembers()) {
                    this.teamByPlayer.put(member, team);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load team: " + teamName);
            }
        }
    }

    public void saveData() {
        try {
            this.dataConfig.set("teams", null);
            for (Map.Entry<String, Team> entry : this.teamsByName.entrySet()) {
                this.dataConfig.set("teams." + entry.getKey(), entry.getValue().serialize());
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save team data to file!");
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public Team getTeam(String name) {
        return this.teamsByName.get(name.toLowerCase());
    }

    public Team getTeam(UUID playerUUID) {
        return this.teamByPlayer.get(playerUUID);
    }

    public boolean teamExists(String name) {
        return this.teamsByName.containsKey(name.toLowerCase());
    }

    public void createTeam(String name, UUID owner) {
        Team team = new Team(name, owner);
        this.teamsByName.put(name.toLowerCase(), team);
        this.teamByPlayer.put(owner, team);
        this.saveDataAsync();
    }

    public void disbandTeam(Team team) {
        this.teamsByName.remove(team.getName().toLowerCase());
        for (UUID member : team.getMembers()) {
            this.teamByPlayer.remove(member);
        }
        this.saveDataAsync();
    }

    public void addInvite(UUID target, Team team) {
        this.pendingInvites.put(target, new TeamInvite(team, System.currentTimeMillis()));
    }

    public TeamInvite getInvite(UUID target) {
        TeamInvite invite = this.pendingInvites.get(target);
        if (invite == null) {
            return null;
        }
        if (System.currentTimeMillis() - invite.timestamp() > 60000L) {
            this.pendingInvites.remove(target);
            return null;
        }
        return invite;
    }

    public void removeInvite(UUID target) {
        this.pendingInvites.remove(target);
    }

    public void joinTeam(Team team, UUID player) {
        team.addMember(player);
        this.teamByPlayer.put(player, team);
        this.saveDataAsync();
    }

    public void leaveTeam(Team team, UUID player) {
        team.removeMember(player);
        this.teamByPlayer.remove(player);
        this.saveDataAsync();
    }

    public record TeamInvite(Team team, long timestamp) {
    }
}

