/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Marker;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MarkerManager {
    private final FoliaCore plugin;
    private final ConcurrentHashMap<UUID, Map<String, Marker>> playerMarkers;
    private final ConcurrentHashMap<UUID, ScheduledTask> activeGpsTasks;
    private File dataFile;
    private FileConfiguration dataConfig;

    public MarkerManager(FoliaCore plugin) {
        this.plugin = plugin;
        this.playerMarkers = new ConcurrentHashMap();
        this.activeGpsTasks = new ConcurrentHashMap();
    }

    public void load() {
        this.dataFile = new File(this.plugin.getDataFolder(), "markers.yml");
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("markers.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadMarkers();
    }

    private void loadMarkers() {
        ConfigurationSection markersSection = this.dataConfig.getConfigurationSection("markers");
        if (markersSection == null) {
            return;
        }
        for (String uuidString : markersSection.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                ConfigurationSection playerMarkerSection = markersSection.getConfigurationSection(uuidString);
                if (playerMarkerSection == null) continue;
                ConcurrentHashMap<String, Marker> markers = new ConcurrentHashMap<String, Marker>();
                for (String markerName : playerMarkerSection.getKeys(false)) {
                    ConfigurationSection markerSection = playerMarkerSection.getConfigurationSection(markerName);
                    if (markerSection == null) continue;
                    Map markerData = markerSection.getValues(false);
                    markers.put(markerName.toLowerCase(), Marker.deserialize(markerName, markerData));
                }
                this.playerMarkers.put(playerUUID, markers);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load markers for invalid UUID: " + uuidString);
            }
        }
    }

    public void saveData() {
        try {
            this.dataConfig.set("markers", null);
            for (Map.Entry<UUID, Map<String, Marker>> entry : this.playerMarkers.entrySet()) {
                String uuidString = entry.getKey().toString();
                for (Map.Entry<String, Marker> markerEntry : entry.getValue().entrySet()) {
                    this.dataConfig.set("markers." + uuidString + "." + markerEntry.getKey(), markerEntry.getValue().serialize());
                }
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save marker data to file!");
            e.printStackTrace();
        }
    }

    private void saveDataAsync() {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.saveData());
    }

    public void setMarker(UUID playerUUID, String name, Location location) {
        Marker marker = new Marker(name, location);
        this.playerMarkers.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(name.toLowerCase(), marker);
        this.saveDataAsync();
    }

    public void deleteMarker(UUID playerUUID, String name) {
        Map<String, Marker> markers = this.playerMarkers.get(playerUUID);
        if (markers != null) {
            markers.remove(name.toLowerCase());
            this.saveDataAsync();
        }
    }

    public Marker getMarker(UUID playerUUID, String name) {
        Map<String, Marker> markers = this.playerMarkers.get(playerUUID);
        if (markers == null) {
            return null;
        }
        return markers.get(name.toLowerCase());
    }

    public Map<String, Marker> getMarkers(UUID playerUUID) {
        return this.playerMarkers.getOrDefault(playerUUID, Collections.emptyMap());
    }

    public boolean isGpsActive(UUID playerUUID) {
        return this.activeGpsTasks.containsKey(playerUUID);
    }

    public void stopGps(Player player) {
        ScheduledTask task = this.activeGpsTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
            player.sendActionBar((Component)Component.text((String)"GPS navigation stopped.", (TextColor)NamedTextColor.RED));
        }
    }

    public void startGps(Player player, Marker marker) {
        this.stopGps(player);
        Location targetLocation = marker.toLocation();
        if (targetLocation == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "The world for that marker is not loaded!");
            return;
        }
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Starting GPS to " + marker.name() + ". Look at your action bar. Type /gps off to stop.");
        ScheduledTask task = player.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> {
            if (!player.isOnline()) {
                scheduledTask.cancel();
                this.activeGpsTasks.remove(player.getUniqueId());
                return;
            }
            Location playerLoc = player.getLocation();
            if (!playerLoc.getWorld().equals((Object)targetLocation.getWorld())) {
                player.sendActionBar((Component)Component.text((String)("Wrong World! Target is in " + marker.worldName()), (TextColor)NamedTextColor.RED));
                return;
            }
            double distance = playerLoc.distance(targetLocation);
            if (distance < 5.0) {
                player.sendActionBar((Component)Component.text((String)("You have arrived at " + marker.name() + "!"), (TextColor)NamedTextColor.GREEN));
                scheduledTask.cancel();
                this.activeGpsTasks.remove(player.getUniqueId());
                return;
            }
            Vector direction = targetLocation.toVector().subtract(playerLoc.toVector()).normalize();
            String arrow = this.getArrow(playerLoc.getYaw(), direction);
            String distanceString = String.format("%,.0f", distance) + "m";
            BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)arrow, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)(" " + marker.name() + " | "), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)distanceString, (TextColor)NamedTextColor.GOLD))).build();
            player.sendActionBar((Component)message);
        }, null, 1L, 20L);
        this.activeGpsTasks.put(player.getUniqueId(), task);
    }

    private String getArrow(float playerYaw, Vector direction) {
        playerYaw = (playerYaw % 360.0f + 360.0f) % 360.0f;
        double vectorAngle = Math.toDegrees(Math.atan2(-direction.getX(), direction.getZ()));
        double angle = (vectorAngle - (double)playerYaw) % 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle <= 22.5 || angle > 337.5) {
            return "\u2b06";
        }
        if (angle > 22.5 && angle <= 67.5) {
            return "\u2197";
        }
        if (angle > 67.5 && angle <= 112.5) {
            return "\u27a1";
        }
        if (angle > 112.5 && angle <= 157.5) {
            return "\u2198";
        }
        if (angle > 157.5 && angle <= 202.5) {
            return "\u2b07";
        }
        if (angle > 202.5 && angle <= 247.5) {
            return "\u2199";
        }
        if (angle > 247.5 && angle <= 292.5) {
            return "\u2b05";
        }
        if (angle > 292.5 && angle <= 337.5) {
            return "\u2196";
        }
        return "?";
    }
}

