/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.managers;

import dev.ajaretro.foliaCore.FoliaCore;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final FoliaCore plugin;
    private Economy econ = null;

    public EconomyManager(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public void load() {
        if (!this.setupEconomy()) {
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "===================================================");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "VAULT NOT FOUND! Economy features will be disabled.");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "Please install Vault and an economy plugin (like EssentialsX Eco).");
            this.plugin.getLogger().severe(String.valueOf(ChatColor.DARK_RED) + "===================================================");
        }
    }

    private boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public boolean hasEconomy() {
        return this.econ != null;
    }

    public String format(double amount) {
        return this.econ.format(amount);
    }

    public double getBalance(OfflinePlayer player) {
        return this.econ.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.econ.has(player, amount);
    }

    public EconomyResponse withdraw(OfflinePlayer player, double amount) {
        return this.econ.withdrawPlayer(player, amount);
    }

    public EconomyResponse deposit(OfflinePlayer player, double amount) {
        return this.econ.depositPlayer(player, amount);
    }
}

