/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.listeners;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Kit;
import dev.ajaretro.foliaCore.gui.KitGUI;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitGUIListener
implements Listener {
    private final FoliaCore plugin;

    public KitGUIListener(FoliaCore plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(KitGUI.GUI_TITLE)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        Component displayNameComponent = meta.displayName();
        if (displayNameComponent == null) {
            return;
        }
        String kitName = this.plugin.getMessenger().componentToString(displayNameComponent);
        Kit kit = this.plugin.getKitManager().getKit(kitName);
        if (kit == null) {
            return;
        }
        player.closeInventory();
        this.plugin.getKitManager().giveKit(player, kit);
    }
}

