/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.listeners;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.ChatMode;
import dev.ajaretro.foliaCore.managers.ChatManager;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ChatListener
implements Listener {
    private final FoliaCore plugin;
    private final ChatManager chatManager;

    public ChatListener(FoliaCore plugin) {
        this.plugin = plugin;
        this.chatManager = plugin.getChatManager();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        ChatMode mode;
        Player player = event.getPlayer();
        if (this.chatManager.isMuted(player.getUniqueId())) {
            event.setCancelled(true);
            this.plugin.getMessenger().sendError((CommandSender)player, "You are muted and cannot speak.");
            return;
        }
        if (!this.chatManager.isChatRangesEnabled()) {
            return;
        }
        String messageString = this.plugin.getMessenger().componentToString(event.originalMessage());
        String globalPrefix = this.chatManager.getGlobalPrefix();
        boolean isGlobal = false;
        if (messageString.startsWith(globalPrefix)) {
            String messageWithoutPrefix = messageString.substring(globalPrefix.length()).trim();
            event.message((Component)Component.text((String)messageWithoutPrefix));
            isGlobal = true;
        }
        if ((mode = this.chatManager.getPlayerChatMode(player.getUniqueId())) == ChatMode.GLOBAL || isGlobal) {
            return;
        }
        Collection viewers = event.viewers().stream().filter(audience -> audience instanceof Player).map(audience -> (Player)audience).collect(Collectors.toList());
        event.viewers().clear();
        if (mode == ChatMode.WORLD) {
            for (Player viewer : viewers) {
                if (!viewer.getWorld().equals((Object)player.getWorld())) continue;
                event.viewers().add(viewer);
            }
        } else if (mode == ChatMode.REGIONAL) {
            int radius = this.chatManager.getRegionalRadius();
            for (Player viewer : viewers) {
                if (!viewer.getWorld().equals((Object)player.getWorld()) || !(viewer.getLocation().distanceSquared(player.getLocation()) <= (double)(radius * radius))) continue;
                event.viewers().add(viewer);
            }
        }
        event.viewers().add(player);
    }
}

