/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Warp;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class WarpsCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public WarpsCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("foliacore.warps.list")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to list warps.");
            return true;
        }
        boolean isAdmin = sender.hasPermission("foliacore.warp.all");
        String warpsList = this.plugin.getWarpManager().getAllWarps().stream().map(Warp::name).filter(name -> isAdmin || sender.hasPermission("foliacore.warp." + name.toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.WHITE)));
        if (warpsList.isEmpty()) {
            this.plugin.getMessenger().sendMessage(sender, "There are no warps available for you.");
        } else {
            this.plugin.getMessenger().sendMessage(sender, "Available Warps: " + String.valueOf(ChatColor.WHITE) + warpsList);
        }
        return true;
    }
}

