/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UnmuteCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public UnmuteCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("foliacore.unmute")) {
            this.plugin.getMessenger().sendError(sender, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError(sender, "Usage: /unmute <player>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore()) {
            this.plugin.getMessenger().sendError(sender, "Player not found.");
            return true;
        }
        this.plugin.getChatManager().unmutePlayer(target.getUniqueId());
        this.plugin.getMessenger().sendSuccess(sender, target.getName() + " has been unmuted.");
        Player onlineTarget = target.getPlayer();
        if (onlineTarget != null) {
            onlineTarget.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendSuccess((CommandSender)onlineTarget, "You have been unmuted."), null);
        }
        return true;
    }
}

