/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpaCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public TpaCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.tpa")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /tpa <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Player not found or is not online.");
            return true;
        }
        if (player.equals((Object)target)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You cannot send a teleport request to yourself.");
            return true;
        }
        this.plugin.getTeleportManager().createTpaRequest(player.getUniqueId(), target.getUniqueId(), TeleportManager.TpaType.TPA);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Teleport request sent to " + target.getName() + ".");
        target.getScheduler().run((Plugin)this.plugin, task -> {
            this.plugin.getMessenger().sendMessage((CommandSender)target, String.valueOf(ChatColor.GOLD) + player.getName() + String.valueOf(ChatColor.WHITE) + " has requested to teleport to you.");
            this.plugin.getMessenger().sendMessage((CommandSender)target, "Type " + String.valueOf(ChatColor.GREEN) + "/tpaccept" + String.valueOf(ChatColor.WHITE) + " or " + String.valueOf(ChatColor.RED) + "/tpdeny");
        }, null);
        return true;
    }
}

