/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpAcceptCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeleportManager tm;

    public TpAcceptCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeleportManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.tpaccept")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        TeleportManager.TeleportRequest request = this.tm.getTpaRequest(player.getUniqueId());
        if (request == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You have no pending teleport requests.");
            return true;
        }
        this.tm.removeTpaRequest(player.getUniqueId());
        Player requester = Bukkit.getPlayer((UUID)request.requester());
        if (requester == null || !requester.isOnline()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "The other player is no longer online.");
            return true;
        }
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Teleport request accepted.");
        requester.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendSuccess((CommandSender)requester, player.getName() + " accepted your teleport request."), null);
        if (request.type() == TeleportManager.TpaType.TPA) {
            this.tm.startTeleport(requester, player.getLocation(), "Teleported to " + String.valueOf(ChatColor.GOLD) + player.getName());
        } else {
            this.tm.startTeleport(player, requester.getLocation(), "Teleported " + String.valueOf(ChatColor.GOLD) + player.getName() + String.valueOf(ChatColor.GREEN) + " to you.");
        }
        return true;
    }
}

