/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Team;
import dev.ajaretro.foliaCore.managers.TeamManager;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeamCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeamManager tm;
    private static final Pattern TEAM_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,16}$");

    public TeamCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeamManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.handleHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "disband": {
                this.handleDisband(player);
                break;
            }
            case "invite": {
                this.handleInvite(player, args);
                break;
            }
            case "accept": {
                this.handleAccept(player, args);
                break;
            }
            case "decline": {
                this.handleDecline(player);
                break;
            }
            case "leave": {
                this.handleLeave(player);
                break;
            }
            case "kick": {
                this.handleKick(player, args);
                break;
            }
            case "info": 
            case "who": {
                this.handleInfo(player, args);
                break;
            }
            default: {
                this.handleHelp(player);
            }
        }
        return true;
    }

    private void handleHelp(Player player) {
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "--- FoliaCore Team Help ---");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team create <name>" + String.valueOf(ChatColor.WHITE) + " - Create a new team.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team invite <player>" + String.valueOf(ChatColor.WHITE) + " - Invite a player to your team.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team accept [name]" + String.valueOf(ChatColor.WHITE) + " - Accept a team invite.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team decline" + String.valueOf(ChatColor.WHITE) + " - Decline a team invite.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team kick <player>" + String.valueOf(ChatColor.WHITE) + " - Kick a player from your team.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team leave" + String.valueOf(ChatColor.WHITE) + " - Leave your current team.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team disband" + String.valueOf(ChatColor.WHITE) + " - Disband your team.");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/team info [name]" + String.valueOf(ChatColor.WHITE) + " - Get info on a team.");
    }

    private void handleCreate(Player player, String[] args) {
        if (!player.hasPermission("foliacore.team.create")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to create a team.");
            return;
        }
        if (this.tm.getTeam(player.getUniqueId()) != null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are already in a team. You must leave it first.");
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /team create <name>");
            return;
        }
        String teamName = args[1];
        if (!TEAM_NAME_PATTERN.matcher(teamName).matches()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Team name must be 3-16 characters and only contain letters, numbers, and underscores.");
            return;
        }
        if (this.tm.teamExists(teamName)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "A team with that name already exists.");
            return;
        }
        this.tm.createTeam(teamName, player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have created the team: " + String.valueOf(ChatColor.GOLD) + teamName);
    }

    private void handleDisband(Player player) {
        if (!player.hasPermission("foliacore.team.disband")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to disband a team.");
            return;
        }
        Team team = this.tm.getTeam(player.getUniqueId());
        if (team == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are not in a team.");
            return;
        }
        if (!team.isOwner(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are not the owner of this team.");
            return;
        }
        String teamName = team.getName();
        this.notifyTeam(team, player.getUniqueId(), String.valueOf(ChatColor.RED) + "Your team has been disbanded by " + player.getName() + ".");
        this.tm.disbandTeam(team);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have disbanded your team: " + String.valueOf(ChatColor.GOLD) + teamName);
    }

    private void handleInvite(Player player, String[] args) {
        if (!player.hasPermission("foliacore.team.invite")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to invite players.");
            return;
        }
        Team team = this.tm.getTeam(player.getUniqueId());
        if (team == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are not in a team.");
            return;
        }
        if (!team.isOwner(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Only the team owner can invite players.");
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /team invite <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null || !target.isOnline()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Player not found or is not online.");
            return;
        }
        if (this.tm.getTeam(target.getUniqueId()) != null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "That player is already in a team.");
            return;
        }
        this.tm.addInvite(target.getUniqueId(), team);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Invite sent to " + String.valueOf(ChatColor.GOLD) + target.getName());
        target.getScheduler().run((Plugin)this.plugin, task -> {
            this.plugin.getMessenger().sendMessage((CommandSender)target, String.valueOf(ChatColor.GOLD) + player.getName() + String.valueOf(ChatColor.WHITE) + " has invited you to join their team: " + String.valueOf(ChatColor.GOLD) + team.getName());
            this.plugin.getMessenger().sendMessage((CommandSender)target, "Type " + String.valueOf(ChatColor.GREEN) + "/team accept " + team.getName() + String.valueOf(ChatColor.WHITE) + " to join. This invite will expire in 60 seconds.");
        }, null);
    }

    private void handleAccept(Player player, String[] args) {
        if (!player.hasPermission("foliacore.team.accept")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to accept invites.");
            return;
        }
        TeamManager.TeamInvite invite = this.tm.getInvite(player.getUniqueId());
        if (invite == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have a pending team invite.");
            return;
        }
        if (args.length > 1 && !invite.team().getName().equalsIgnoreCase(args[1])) {
            this.plugin.getMessenger().sendError((CommandSender)player, "That is not the correct team name. Your invite is for: " + String.valueOf(ChatColor.GOLD) + invite.team().getName());
            return;
        }
        if (this.tm.getTeam(player.getUniqueId()) != null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are already in a team. You must leave it first.");
            return;
        }
        this.tm.removeInvite(player.getUniqueId());
        this.tm.joinTeam(invite.team(), player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have joined the team: " + String.valueOf(ChatColor.GOLD) + invite.team().getName());
        this.notifyTeam(invite.team(), player.getUniqueId(), String.valueOf(ChatColor.GREEN) + player.getName() + " has joined the team!");
    }

    private void handleDecline(Player player) {
        TeamManager.TeamInvite invite = this.tm.getInvite(player.getUniqueId());
        if (invite == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have a pending team invite.");
            return;
        }
        this.tm.removeInvite(player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have declined the invite from " + String.valueOf(ChatColor.GOLD) + invite.team().getName());
        Player owner = Bukkit.getPlayer((UUID)invite.team().getOwner());
        if (owner != null && owner.isOnline()) {
            owner.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendError((CommandSender)owner, player.getName() + " has declined your team invite."), null);
        }
    }

    private void handleLeave(Player player) {
        if (!player.hasPermission("foliacore.team.leave")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to leave a team.");
            return;
        }
        Team team = this.tm.getTeam(player.getUniqueId());
        if (team == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are not in a team.");
            return;
        }
        if (team.isOwner(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are the owner. You must disband the team or transfer ownership.");
            return;
        }
        this.tm.leaveTeam(team, player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have left the team: " + String.valueOf(ChatColor.GOLD) + team.getName());
        this.notifyTeam(team, player.getUniqueId(), String.valueOf(ChatColor.RED) + player.getName() + " has left the team.");
    }

    private void handleKick(Player player, String[] args) {
        if (!player.hasPermission("foliacore.team.kick")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to kick players.");
            return;
        }
        Team team = this.tm.getTeam(player.getUniqueId());
        if (team == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You are not in a team.");
            return;
        }
        if (!team.isOwner(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Only the team owner can kick players.");
            return;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /team kick <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (target == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Player not found.");
            return;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You cannot kick yourself.");
            return;
        }
        if (!team.isMember(target.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "That player is not in your team.");
            return;
        }
        this.tm.leaveTeam(team, target.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "You have kicked " + String.valueOf(ChatColor.GOLD) + target.getName() + String.valueOf(ChatColor.GREEN) + " from the team.");
        this.notifyTeam(team, player.getUniqueId(), String.valueOf(ChatColor.RED) + target.getName() + " has been kicked from the team.");
        if (target.isOnline()) {
            Player onlineTarget = target.getPlayer();
            onlineTarget.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendError((CommandSender)onlineTarget, "You have been kicked from the team by " + player.getName()), null);
        }
    }

    private void handleInfo(Player player, String[] args) {
        OfflinePlayer owner;
        Team team;
        if (args.length < 2) {
            team = this.tm.getTeam(player.getUniqueId());
            if (team == null) {
                this.plugin.getMessenger().sendError((CommandSender)player, "You are not in a team. Usage: /team info <name>");
                return;
            }
        } else {
            team = this.tm.getTeam(args[1]);
            if (team == null) {
                this.plugin.getMessenger().sendError((CommandSender)player, "No team found with that name.");
                return;
            }
        }
        String ownerName = (owner = Bukkit.getOfflinePlayer((UUID)team.getOwner())).getName() != null ? owner.getName() : "Unknown";
        String membersList = team.getMembers().stream().map(uuid -> {
            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
            return p.isOnline() ? String.valueOf(ChatColor.GREEN) + p.getName() : String.valueOf(ChatColor.GRAY) + p.getName();
        }).collect(Collectors.joining(String.valueOf(ChatColor.WHITE) + ", "));
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "--- Team Info: " + String.valueOf(ChatColor.GOLD) + team.getName() + " ---");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "Owner: " + String.valueOf(ChatColor.RED) + ownerName);
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "Members (" + team.getSize() + "): " + membersList);
    }

    private void notifyTeam(Team team, UUID playerToSkip, String message) {
        for (UUID memberUUID : team.getMembers()) {
            Player member;
            if (memberUUID.equals(playerToSkip) || (member = Bukkit.getPlayer((UUID)memberUUID)) == null || !member.isOnline()) continue;
            member.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendMessage((CommandSender)member, message), null);
        }
    }
}

